/************************************************************************
  * FILE:         IDbusManagerProxy.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Interface definition for the Linux specific calls
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2012 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 19.11.2012  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/

#ifndef _IDBUSMANAGER_PROXY_H
#define _IDBUSMANAGER_PROXY_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcm_AppMain.h"

#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_STDVISITORS
#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_FUNCTIONIDS
#include "lcm_fi_if.h"

namespace org {
namespace bosch {
namespace cm {
namespace lcm {

class IDbusProxy;

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes
class IDbusManagerProxy : public lcm_tclBaseIf
{
public:
IDbusManagerProxy(const lcm_tclAppMain *poMainAppl) : lcm_tclBaseIf(poMainAppl){ _poIDbusProxy = NULL; }
virtual ~IDbusManagerProxy(){ _poIDbusProxy = NULL; }

virtual const tChar*getIfName() const { return( "IDbusManagerProxy" ); }

// start/stop units
virtual void vStartUnit(const char *UnitName)                 = 0;

virtual void vStopUnit(const char *UnitName)                  = 0;

virtual void vRestartUnit(const char *UnitName)               = 0;

// failed unit List handling
virtual void vTriggerGetListUnit()                            = 0;

virtual const lcm_fi_tcl_SPM_ServiceList& GetUnitList() const = 0;

protected:
IDbusProxy                               *_poIDbusProxy;
};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // _IDBUSMANAGER_PROXY_H

