/****************************************************************************
  * Copyright (C) Robert Bosch Car Multimedia GmbH, 2013
  * This software is property of Robert Bosch GmbH. Unauthorized
  * duplication and disclosure to third parties is prohibited.
  ***************************************************************************/

/*!
  * \file     DbusManagerProxy.h
  * \brief    Implementation of the systemd ManagerProxy interface
  *           Start and stop units via systemd
  *
  * \author   klaus-peter.kollai@de.bosch.com CM-AI/PJ-CB32
  *
  * \par Copyright:
  * (c) 2013-2013 Robert Bosch Car Multimedia GmbH
  ***************************************************************************/
#ifndef __LCMDBUSMANAGERPROXY_H
#define __LCMDBUSMANAGERPROXY_H

#include "asf/core/Logger.h"

#include "org/freedesktop/systemd1/ManagerProxy.h"

#include "lcm_AppMain.h"
#include "IDbusManagerProxy.h"

#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_STDVISITORS
#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_FUNCTIONIDS
#include "lcm_fi_if.h"
//  boost::shared_ptr is used here cause by ASF interface.
namespace org {
namespace bosch {
namespace cm {
namespace lcm {

/*!
   \brief contains all info needed to interact with the Manager interface of systemd
  */
class AsfManagerProxy
{
public:
AsfManagerProxy()
   : _u32JobNewRegisterId(0),
   _u32JobRemovedRegisterId(0),
   _u32StartupFinishedRegisterId(0),
   _u32VersionRegisterId(0),
   _u32SubscribeRegisterId(0){}
uint32      _u32JobNewRegisterId;
uint32      _u32JobRemovedRegisterId;
uint32      _u32StartupFinishedRegisterId;
uint32      _u32VersionRegisterId;
uint32      _u32SubscribeRegisterId;
std::string strJobId;
};

/*!
   \brief implements the interaction with the Manager object of systemd
  */
class DbusManagerProxy : public IDbusManagerProxy
   , private ::asf::core::ServiceAvailableIF
   // , Manager
   , private ::org::freedesktop::systemd1::Manager::JobNewCallbackIF
   , private ::org::freedesktop::systemd1::Manager::JobRemovedCallbackIF
   , private ::org::freedesktop::systemd1::Manager::GetUnitCallbackIF
   , private ::org::freedesktop::systemd1::Manager::StartUnitCallbackIF
   , private ::org::freedesktop::systemd1::Manager::StopUnitCallbackIF
   , private ::org::freedesktop::systemd1::Manager::RestartUnitCallbackIF
   , private ::org::freedesktop::systemd1::Manager::ListJobsCallbackIF
   , private ::org::freedesktop::systemd1::Manager::VersionCallbackIF
   , private ::org::freedesktop::systemd1::Manager::ListUnitsCallbackIF
   , private ::org::freedesktop::systemd1::Manager::StartupFinishedCallbackIF
   , private ::org::freedesktop::systemd1::Manager::SubscribeCallbackIF
{
private:
lcm_fi_tcl_SPM_ServiceList _ServiceFailedEntryList;
std::set < std::string >   _SystemdUnitFailedWhitelistSet;

/*! \var is the default mode for StartUnit !*/
const ::std::string        _JobMode;

DECLARE_CLASS_LOGGER();

public:
DbusManagerProxy(lcm_tclAppMain *poMainAppl);
virtual ~DbusManagerProxy();

// ISpmBase methods
virtual tVoid vHandleMessage(lcm_tclBaseIf::TMsg */*pMsg*/){}

virtual tVoid vGetReferences(){}
virtual tVoid vStartCommunication();

virtual tVoid vTraceInfo(){}

virtual tVoid vHandleTraceMessage(const tUChar */*puchData*/){}
virtual const tChar*getName() const { return( "DbusManagerProxy" ); }

// start/stop units
virtual void vStartUnit(const char *UnitName);

virtual void vStopUnit(const char *UnitName);

virtual void vRestartUnit(const char *UnitName);


// failed unit List handling
virtual void vTriggerGetListUnit();

virtual const lcm_fi_tcl_SPM_ServiceList& GetUnitList() const { return( _ServiceFailedEntryList ); }

// ######################################
// ASF-Core implementations
// ######################################
// ServiceAvailableIF implementation
virtual void onAvailable(const boost::shared_ptr < ::asf::core::Proxy >& proxy,
                         const ::asf::core::ServiceStateChange         & stateChange);

virtual void onUnavailable(const boost::shared_ptr < ::asf::core::Proxy >& proxy,
                           const ::asf::core::ServiceStateChange         & stateChange);

// ######################################
// ManagerProxy implementations
// ######################################
// JobNewSignalCallbackIF implementation
virtual void onJobNewSignal(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >& proxy,
                            const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::JobNewSignal >& signal);

virtual void onJobNewError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >& proxy,
                           const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::JobNewError > & error);

// JobRemovedSignalCallbackIF implementation
virtual void onJobRemovedSignal(const boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >      & proxy,
                                const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::JobRemovedSignal >& signal);

virtual void onJobRemovedError(const boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >     & proxy,
                               const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::JobRemovedError >& error);

// GetUnitMethodCallbackIF implementation
virtual void onGetUnitResponse(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >   & proxy,
                               const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::GetUnitResponse >& response);

virtual void onGetUnitError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >& proxy,
                            const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::GetUnitError >& error);

// StartUnitCallbackIF implementation
virtual void onStartUnitResponse(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >     & proxy,
                                 const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::StartUnitResponse >& response);

virtual void onStartUnitError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >  & proxy,
                              const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::StartUnitError >& error);

// StopUnitMethodCallbackIF implementation
virtual void onStopUnitResponse(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >    & proxy,
                                const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::StopUnitResponse >& response);

virtual void onStopUnitError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy > & proxy,
                             const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::StopUnitError >& error);
// RestartUnitMethodCallbackIF implementation
virtual void onRestartUnitResponse(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >    & proxy,
                                const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::RestartUnitResponse >& response);

virtual void onRestartUnitError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy > & proxy,
                             const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::RestartUnitError >& error);
// ListJobsMethodCallbackIF implementation
virtual void onListJobsResponse(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >    & proxy,
                                const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ListJobsResponse >& response);

virtual void onListJobsError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy > & proxy,
                             const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ListJobsError >& error);

// VersionCallbackIF
virtual void onVersionUpdate(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy > & proxy,
                             const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::VersionUpdate >& update);

virtual void onVersionError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >& proxy,
                            const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::VersionError >& error);

// ListUnitsCallbackIF
virtual void onListUnitsResponse(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >     & proxy,
                                 const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ListUnitsResponse >& response);

virtual void onListUnitsError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >  & proxy,
                              const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ListUnitsError >& error);

// StartupFinishedCallbackIF
virtual void onStartupFinishedSignal(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >         & proxy,
                                     const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::StartupFinishedSignal >& signal);

virtual void onStartupFinishedError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >        & proxy,
                                    const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::StartupFinishedError >& error);

//SubscribeCallbackIF
virtual void onSubscribeResponse(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >     & proxy,
                                 const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::SubscribeResponse >& response);

virtual void onSubscribeError(const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy >  & proxy,
                              const ::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::SubscribeError >& error);

private:
::boost::shared_ptr < ::org::freedesktop::systemd1::Manager::ManagerProxy > _managerProxy;
AsfManagerProxy _asfManagerProxy;
};

}
}
}
} // namespace org { namespace bosch { namespace cm { namespace lcm {

#endif // ifndef __LCMDBUSPROXY_H

