/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         ApplicationConfiguration.h
  * @brief        
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#ifndef SPM_APPLICATIONCONFIGURATIONCONFIG_H
   #define SPM_APPLICATIONCONFIGURATIONCONFIG_H

#include <map>
#include <string>
#include "IApplicationConfiguration.h"

/*!
  *  \class spm_tclApplicationConfigurationConfig
  *  \brief This project specific class reads application information.

        The spm_tclFactory object creates an instance of this class. Class spm_tclLocalApplicationManager uses this class to print
        application information.
  */
   class SpmApplicationConfiguration : public ISpmApplicationConfiguration
   {
private:
   std::map < std::string, tU32 >        _mapAppNamesDefines;
   std::map < std::string, std::string > _mapAppNamesServiceName;

public:
   SpmApplicationConfiguration();
   virtual ~SpmApplicationConfiguration();

   virtual tU32 u32GetAppIdByName(const std::string& strName);

   virtual std::string strGetNameByServiceName(std::string strServiceName);
   virtual std::string strGetServiceNameByName(std::string strSwBlockName);

   };


#endif // ifndef SPM_APPLICATIONCONFIGURATIONCONFIG_H

