/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_WorkerServerConfig.h
  * @brief        This is header file provides project specific configuration for worker server.
  *               Server to distribute messages within the FC SPM to support loose coupling.
  * @copyright    (C) 2011 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_WorkerServer.h"

#define SPM_EV_SHUTDOWN_NAME "SpmEvEnd"

/*!
  *  \class spm_tclWorkerServerConfig
  *  \brief This class provides project specific configuration for worker server.

          The spm_tclFactory object creates an instance of this class. Class spm_tclFactory uses this class to set number of start up process.
  */
class spm_tclWorkerServerConfig : public spm_tclWorkerServer
{
public:
spm_tclWorkerServerConfig( const ISpmFactory& factory,
                           const tChar       *pEvName = SPM_EV_SHUTDOWN_NAME );
virtual ~spm_tclWorkerServerConfig( );

virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 );

protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar *puchData );

virtual const tChar*getName( ) const { return( "spm_tclWorkerServerConfig" ); }
virtual tVoid vGetReferences( ){ spm_tclWorkerServer::vGetReferences( ); }
virtual tVoid vStartCommunication( );

private:
virtual tVoid vOnTerminate( );

virtual tVoid vOnMessageQueueError( );

const tChar *_pEvName;
};

