/*!
  * \file spm_WorkerServerConfig.cpp
  *  \brief
  *    Configuration of a message oriented worker server to receive messages from clients and send them back to the client out of
  *     a defined environment
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  *  Date      | Author            | Modification
  * 17.01.11  | TMS Fischer       | initial version
  ******
  */

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_Config.h"
#include "spm_WorkerServerConfig.h"
#include "spm_IFactory.h"
#include "spm_IApplicationErrorHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
 #include "trcGenProj/Header/spm_WorkerServerConfig.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"


// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------
// #define SPM_TRACE_FILE_ID   SPM_FILE_WORKERSERVERCONFIG

spm_tclWorkerServerConfig::spm_tclWorkerServerConfig( const ISpmFactory& factory,
                                                      const tChar       *pEvName )
   : spm_tclWorkerServer( factory )
   , _pEvName( pEvName ){
}

spm_tclWorkerServerConfig::~spm_tclWorkerServerConfig( ){
   _pEvName = NULL;
}

/**
  *  \brief call vStartCommunication of base class
  *
  *  \return void
  */
tVoid spm_tclWorkerServerConfig::vStartCommunication( ){
   spm_tclWorkerServer::vStartCommunication( );
}

tVoid spm_tclWorkerServerConfig::vOnTerminate( ){
}

tVoid spm_tclWorkerServerConfig::vOnMessageQueueError( ){
   ETG_TRACE_ERRMEM( ( "spm_tclWorkerServerConfig::vOnMessageQueueError() Cant post message, error code=%s", OSAL_coszErrorText( OSAL_u32ErrorCode( ) ) ) );
   SPM_GET_IF_REFERENCE_NEW_VAR( poclAppErrHandler, ISpmApplicationErrorHandler );
   poclAppErrHandler->vMsgQueueFull( CCA_C_U16_APP_SPM, false, true );
}

tVoid spm_tclWorkerServerConfig::vHandleMessage( tU32 u32Message,
                                                 tU32 u32Parm ){
   // Terminate the application
   switch ( u32Message ){
      case SPM_U32_WORKER_BROADCAST_VALET_MODE:
      {
         tBool bValetModeActive;
         ETG_TRACE_USR4( ( "spm_tclWorkerServerConfig::vHandleMessage(SPM_U32_WORKER_BROADCAST_VALET_MODE)" ) );

         if ( u32Parm == 1 ){
            bValetModeActive = TRUE;
            vSynchronousCall( SPM_U32_WORKER_BROADCAST_VALET_MODE, &bValetModeActive );
         } else {
            bValetModeActive = FALSE;
            vSynchronousCall( SPM_U32_WORKER_BROADCAST_VALET_MODE, &bValetModeActive );
         }
      }
      break;

      case SPM_U32_WORKER_BROADCAST_STARTUP_ENDED:
         ETG_TRACE_USR4( ( "spm_tclWorkerServerConfig::vHandleMessage(SPM_U32_WORKER_BROADCAST_STARTUP_ENDED) Time=%d Result=%d", OSAL_ClockGetElapsedTime( ), u32Parm ) );
         vSynchronousCall( SPM_U32_WORKER_BROADCAST_STARTUP_ENDED, &u32Parm );
         break;

      default:
         // call base class if message is not recognized here
         spm_tclWorkerServer::vHandleMessage( u32Message, u32Parm );
         break;
   } // switch
}    // vHandleMessage

