/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IWorkerClient.h
  * @brief        This is header file contains interface functions for LCM Worker server and worker client.
  * @copyright    (C) 2011 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_baseClass.h"
#include "spm_ISpmBase.h"

// //////////////////////////////////////////////////////////////////////////////
// Interface to receive events

/*!
  *  \class ISpmWorkerClient
  *  \brief This abstract class provides interfaces spm worker client.
  */
class ISpmWorkerClient : public ISpmBase
{
public:
ISpmWorkerClient( const ISpmFactory& factory ) : ISpmBase( factory ){ }
virtual ~ISpmWorkerClient( ){}
virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 )     = 0;

virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args ) = 0;

};


// //////////////////////////////////////////////////////////////////////////////
// message to be sent to worker server
struct TSpmWorkerMessage
{
   ISpmWorkerClient *_clt;
   tU32 _msg;
   tU32 _parm;
};

// //////////////////////////////////////////////////////////////////////////////
// Interface to send debouncing events

/*!
  *  \class ISpmWorkerServer
  *  \brief This abstract class provides interfaces to add or remove clients and post messages to clients.
          This class also delivers interfaces to change or reset priority and set timer parameters.
  */
class ISpmWorkerServer : public spm_tclActive
   , public ISpmWorkerClient
{
public:
ISpmWorkerServer( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){}
virtual ~ISpmWorkerServer( ){}
virtual tVoid vAddClient( ISpmWorkerClient *pClient )        = 0;

virtual tVoid vRemoveClient( ISpmWorkerClient *pClient )     = 0;

virtual tVoid vHandleMsgQueue( )                             = 0;

// handling of asynchronous events
virtual tBool bPostMessage( const std::string& strClientIfName,
                            tU32               u32Message,
                            tU32               u32Parm = 0 ) = 0;

virtual tBool bPostMessage( const TSpmWorkerMessage& msg )   = 0;

virtual tBool bPostMessageToWorker( tU32 u32Message,
                                    tU32 u32Parm = 0 )       = 0;

virtual tVoid vChangePriority( tU32 u32Priority )            = 0;

virtual tVoid vRestorePriority( )                            = 0;

virtual tVoid vSynchronousCall( tU32   u32Message,
                                tVoid *args )                = 0;

virtual tVoid vSetNumberOfStartupProcesses( tUInt nNumber )  = 0;

virtual tVoid vStart( const std::string& strName,
                      tU32               u32Prio,
                      tU32               u32Stack )          = 0;

virtual tUInt nGetStartupTime( ) const                       = 0;

virtual tVoid vSetStartupTime( )                             = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmWorkerServer" ); }
};

