/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IVersionInfo.h
  * @brief        This is header file contains interfaces to evaluate version information and
  *                  also interfaces to read or write KDS entry.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_IWorkerClient.h"

//tChar not replaced as String constructor not available with only size as parameter.
typedef struct
{
   tChar strBUILDVERSION_LABEL_NOR[20];
   tChar strBUILDVERSION_LABEL_NAND[20];
   tChar strCOMPANY_NAME[30];
   tChar strPRODUCT_NAME[50];
   tChar strPRODUCT_SERIAL_NUMBER[20];
   tChar strPRODUCT_PART_NUMBER[20];
   tChar strSUPPLIER_ECU_SOFTWARE_VERSION_NUMBER[20];
   tChar strSUPPLIER_ECU_HARDWARE_VERSION_NUMBER[20];
   tChar strCONTROLLER_PART_NUMBER[20];
   tChar strCONTROLLER_SUPPLIER[20];
}OSAL_tsDevInfoSystemInfo;


/*!
  *  \class ISpmVersionInfo
  *  \brief This abstract class provides interfaces to evaluate version information.
          This class also supplies interfaces to read or write KDS entry .
        It also supplies interfaces to read system info from file, registry and KDS.
  */
class ISpmVersionInfo : public ISpmWorkerClient
{
public:
ISpmVersionInfo( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmVersionInfo( ){ }
virtual tVoid vGetReferences( )                                   = 0;

virtual tVoid vStartCommunication( )                              = 0;

virtual void TraceBuildversion( )                                 = 0;

virtual tBool bReadKdsEntry( tU32         u32Entry,
                             tU32         u32datalength,
                             tLcmUString *ustrKDSReadData ) const = 0;

virtual tBool bWriteKdsEntry( tU16        key,
                              tLcmUString ustrKDSWriteData,
                              tU16        length ) const          = 0;

virtual tVoid vStoreVersionInfoInEmTrace( tVoid ) = 0;
virtual tVoid vUpdateErrmemVersion( tVoid )       = 0;

virtual const tChar*getName( ) const                              = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmVersionInfo" ); }

protected:
virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 )                                             = 0;

virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args )                                         = 0;

virtual tS32 ReadFromFFD( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoFromFFD ) const           = 0;

virtual tS32 WriteToFFD( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoToFFD ) const              = 0;

virtual tS32 ReadFromRegistry( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoFromRegistry ) const = 0;

virtual tS32 ReadFromFile( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoFromRegistry ) const     = 0;

virtual tS32 ReadFromKDS( OSAL_tsDevInfoSystemInfo *tOsalSystemInfoFromRegistry ) const      = 0;

virtual tBool CheckAndUpdateVersionInfo( ) const                                             = 0;

virtual tVoid vHandleTraceMessage( const tUChar *puchData )                                  = 0;

};

