/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ITrace.h
  * @brief        This is header file contains interface functions for handling LCM trace related functionalities.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IWorkerClient.h"

/*!
  *  \class ISpmTrace
  *  \brief This abstract class provides interfaces for trace client.
  */
class ISpmTrace : public ISpmWorkerClient
{
public:
ISpmTrace( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmTrace( ){ }

virtual tVoid vGetReferences( )                             = 0;

virtual tVoid vStartCommunication( )                        = 0;

// implement trace client interface
virtual tVoid vHandleTraceMessage( const tUChar *puchData ) = 0;

// implementation of interface ISpmWorkerClient
virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 )            = 0;

virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args )        = 0;

virtual const tChar*getName( ) const                        = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmTrace" ); }

virtual tVoid vAddTraceClient( ISpmBase *oTraceClient )     = 0;

virtual tVoid vRemoveTraceClient( ISpmBase *oTraceClient )  = 0;

};

