/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IProcessSupervision.h
  * @brief        This is header file contains interface functions for Process Supervision.
  * @copyright    (C) 2013 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_baseClass.h"
#include "spm_IWorkerClient.h"

/*!
  *  \class ISpmProcessSupervision
  *  \brief This abstract class provides interfaces for spm process supervision.
   This provide interface to dump started process list.
  */
class ISpmProcessSupervision : public spm_tclActive
   , public ISpmWorkerClient
{
public:
// constructor
ISpmProcessSupervision( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmProcessSupervision( ){ }

// Overrides from spm_tclActive
virtual tVoid vOnStart( )                                                            = 0;

virtual tVoid vOnTerminate( )                                                        = 0;

virtual tVoid main( )                                                                = 0;

// Implementation of interface ISpmWorkerClient
virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 )                                     = 0;

virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args )                                 = 0;

// Implementation of interface ISpmBase
virtual const tChar*getName( ) const                                                 = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmProcessSupervision" ); }

virtual tVoid vDumpStartedProcessList( tBool fToErrmem,
                                       tBool fToTrace )                              = 0;

virtual tBool bGetProcessHandleByName( const std::string& pszProcessName,
                                       tU32              *pu32handle )               = 0;

virtual tBool bRemoveProcessFromSupervisionList( const std::string& strProcessName ) = 0;

virtual tBool bSupervisionStop( tVoid )  = 0;
virtual tVoid vSupervisionStart( tVoid ) = 0;

virtual tBool bSupervisionChange( const std::string& strProcessName,
                                  tBool              bSupervisionActive )                 = 0;

virtual tBool bSupervisionChangeAll( tBool bSupervisionActive )                           = 0;

virtual tVoid vRememberAdditionalProzessToSupervise( const std::string& strProcessName,
                                                     tU32               supervisionMode ) = 0;

virtual tVoid vDumpOOMInfo( ) const                                                       = 0;

};

