/*!
  * \file  spm_SupervisionEnableSupervisor_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclSupervisionEnableSupervisor_include_ext: user specific code start
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"
#include "dp_generic_if.h"

#include "spm_SupervisionEnableSupervisor.h"
// spm_tclSupervisionEnableSupervisor_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_SupervisionEnableSupervisor_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclSupervisionEnableSupervisor_include_spm: user specific code start
// spm_tclSupervisionEnableSupervisor_include_spm: user specific code end


tVoid spm_tclSupervisionEnableSupervisor::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SPMRESETSUPERVISIONDISABLE:
      {
         // All supervision resets (WdtHigh, WdtMid, HeartBeatTimeout, CcaQueueFull, ...) triggered by SPM will be ignored. Only a FATAL trace will be triggered.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmResetSupervisionDisable' was called" ) );

         // SpmResetSupervisionDisable: user specific code start
         if ( ( FALSE == _bTTFisDisableRequest_Active ) ){
            ETG_TRACE_FATAL( ( "spm_tclSupervisionEnableSupervisor::vCheckSupervisionDisableRequests() Supervision disabled due to TTFisCommand!" ) );
            _bTTFisDisableRequest_Active = TRUE;
         }
            vCheckSupervisionState( );
         // SpmResetSupervisionDisable: user specific code end
      }
      break;

      case SPM_SPMRESETSUPERVISIONENABLE:
      {
         // SPM resets enabled. See command 'SpmResetSupervisionDisable'.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmResetSupervisionEnable' was called" ) );

         // SpmResetSupervisionEnable: user specific code start
         if ( ( TRUE == _bTTFisDisableRequest_Active ) ){
            ETG_TRACE_FATAL( ( "spm_tclSupervisionEnableSupervisor::vCheckSupervisionDisableRequests() Supervision enabled due to TTFisCommand!" ) );
            _bTTFisDisableRequest_Active = FALSE;
         }
         vCheckSupervisionState( );
         // SpmResetSupervisionEnable: user specific code end
      }
      break;

      case SPM_SPMRESETSUPERVISIONGETSTATE:
      {
         // Prints the current state of the supervision (SpmResetSupervisionDisable/SpmResetSupervisionEnable).

         // SpmResetSupervisionGetState: user specific code start
         ETG_TRACE_FATAL( ( "Supervision states: TTFis: %u, disable_reset.txt %u, WD_OFF %u, external(LCM-internal) %u\n",
                            ETG_ENUM( SPM_TRIGGER_STATE, _bTTFisDisableRequest_Active ),
                            ETG_ENUM( SPM_TRIGGER_STATE, _bDisableResetFileRequest_Active ),
                            ETG_ENUM( SPM_TRIGGER_STATE, _bWdOffDebugSwitchRequest_Active ),
                            ETG_ENUM( SPM_TRIGGER_STATE, _bExternalDisableRequest_Active )
                            ) );
         // SpmResetSupervisionGetState: user specific code end
      }
      break;

      case SPM_SPMRESETSUPERVISIONSAVEPERSISTENT:
      {
         // Saves the current state of the supervision (SpmResetSupervisionDisable/SpmResetSupervisionEnable) persistently.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmResetSupervisionSavePersistent' was called" ) );

         // SpmResetSupervisionSavePersistent: user specific code start
         dp_tclSpmDpFeatureDisableSupervision oDisableSupervision;
         if ( _bGlobalSupervisionStatus == TRUE ){
            // set counter of starts where supervision is disabled to configured value
            oDisableSupervision << (tU8)SPM_U8_DEFAULT_NUMBER_OF_STARTS_WITHOUT_SUPERVISION;
         } else {
            // set counter of starts where supervision is disabled to 0
            oDisableSupervision << (tU8)0;
         }
         // SpmResetSupervisionSavePersistent: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclSupervisionEnableSupervisorFunction: user specific code start
     // spm_tclSupervisionEnableSupervisorFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclSupervisionEnableSupervisorFile: user specific code start
// spm_tclSupervisionEnableSupervisorFile: user specific code end

