/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SupervisionEnableSupervisor.h
  * @brief        This is header file contains functions for SupervisionEnableSupervisor.
  * @copyright    (C) 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_ISupervisionEnableSupervisor.h"

/*!
  *  \class spm_tclSupervisionEnableSupervisor
  *  \brief
  *    Implementation of the check if Supervision in LCM is enabled or not
  *
  */
class spm_tclSupervisionEnableSupervisor : public ISpmSupervisionEnableSupervisor
{
public:
spm_tclSupervisionEnableSupervisor( const ISpmFactory& factory );
virtual ~spm_tclSupervisionEnableSupervisor( );

virtual tVoid vHandleTraceMessage( const tUChar *puchData );

virtual tVoid vSupervisionStop( );

virtual tVoid vSupervisionStart( );

virtual tBool bIsSupervisionStopped( ){ return( !_bGlobalSupervisionStatus ); }

// interface functions ISpmSupervisionClient
virtual tVoid vTraceInfo( );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSupervisionEnableSupervisor" ); }
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual tVoid vStartLateCommunication( );

ISpmSupervisionManager *_poclSupervisionManager;

// interface functions ISpmSupervisionClient
virtual tVoid vCheckSupervisionState( );

virtual tVoid vTriggerSupervisionState( );

virtual tVoid vSetCount( tU32 /*u32Count*/ ){ } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

private:
virtual tVoid vCheckSupervisionDisableRequests( );

static spm_tclSupervisionEnableSupervisor *_pMyStaticRef;
tBool                                      _bGlobalSupervisionStatus;
tBool                                      _bTTFisDisableRequest_Active;
tBool                                      _bDisableResetFileRequest_Active;
tBool                                      _bWdOffDebugSwitchRequest_Active;
tBool                                      _bExternalDisableRequest_Active;
};

