/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          spm_RamLoadSupervisor.h
  * @PROJECT:      CMD project
  * @brief         include header file
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ISuperVisionClient.h"

class ISpmLxRamInfo {
public:
ISpmLxRamInfo( ){}
virtual ~ISpmLxRamInfo( ){}

virtual tU32 u32GetRamUsage( tVoid ) = 0;
virtual tBool bReadStatusFromProcFileSystem( tVoid ) = 0;
};

class spm_tclLxRamInfo : public ISpmLxRamInfo {
public:
spm_tclLxRamInfo( );
virtual ~spm_tclLxRamInfo( );

tU32 u32GetRamUsage( tVoid );

tBool bReadStatusFromProcFileSystem( tVoid );

private:
   tU32 u32MemTotal;
   tU32 u32MemFree;
};

class spm_tclRamLoadSupervisor : public ISpmSupervisionClient
{
public:
spm_tclRamLoadSupervisor( const ISpmFactory& factory );
virtual ~spm_tclRamLoadSupervisor( );

spm_tclRamLoadSupervisor( const spm_tclRamLoadSupervisor& coRef ):ISpmSupervisionClient( coRef ){}
spm_tclRamLoadSupervisor& operator=(const spm_tclRamLoadSupervisor& coRef){ if (this == &coRef) return *this; }

// interface functions ISpmBase
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

// interface functions ISpmSupervisionClient
virtual tVoid vCheckSupervisionState( );

virtual tVoid vTriggerSupervisionState( ) { };

virtual tVoid vTraceInfo( );

virtual tVoid vSetCount( tU32 u32Count ){ _u32TriggerCount = u32Count; }

virtual const tChar*getName( ) const { return( "spm_tclRamLoadSupervisor" ); }

protected:
ISpmLxRamInfo                                *_oRamInfo;

private:

ISpmSupervisionManager                       *_poclSupervisionManager;
ISpmSystemLoadStatistics                     *_poclRamUsageStatistic;

// spm_tclLxRamInfo                              _oRamInfo;
tU32                                          _u32TriggerCount;
tU32                                          _u32RamUsageCheckPeriodS;

};
