/*****************************************************************************
 * FILE:         spm_IgnitionOffSupervisor.h
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * DESCRIPTION:  A software watchdog base implementation
 *
 * ----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author               | Modification
 * 23.09.13  | CM-AI/PJVW32 Kollai  | initial version
 *
 *****************************************************************************/

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ISuperVisionClient.h"

class spm_tclIgnitionOffSupervisor : public ISpmSupervisionClient
{

public:
spm_tclIgnitionOffSupervisor( const ISpmFactory& factory );
virtual ~spm_tclIgnitionOffSupervisor( );

// interface functions ISpmBase
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual tVoid vStartLateCommunication( );

// interface functions ISpmSupervisionClient
virtual tVoid vCheckSupervisionState( );

virtual tVoid vTriggerSupervisionState( );

virtual tVoid vStartSupervision( );

virtual tVoid vStopSupervision( );

virtual tVoid vSetCount( tU32 u32Count );

virtual const tChar*getName( ) const { return( "spm_tclIgnitionOffSupervisor" ); }

virtual tVoid vTraceInfo( );

protected:
tU32                    _u32Clamp15OffCount;
tU32                    _u32WdtClamp15Time;

ISpmSubStateClient     *_poclSubStateHandler;
ISpmSystemPowerManager *_poclSystemPowerManager;

tVoid vUpdateTime( );

};

