/*****************************************************************************
 * FILE:         spm_ISuperVisionClient.h
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * DESCRIPTION:  \todo
 *
 * ---------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author               | Modification
 * 21.09.13  | CM-AI/PJVW32 Kollai  | initial version
 *
 *****************************************************************************/

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_IWorkerClient.h"
#include "spm_factory.h"

class ISpmSupervisionClient : public ISpmWorkerClient
{
protected:
tBool _bTriggeringEnabled;
tBool _bStopSupervision;
tBool _bSupervisionEnabled;

public:
ISpmSupervisionClient( const ISpmFactory& factory ) : ISpmWorkerClient( factory ),
   _bTriggeringEnabled( TRUE ),
   _bStopSupervision( FALSE ),
   _bSupervisionEnabled( FALSE ){
}

virtual ~ISpmSupervisionClient( ){
}

virtual tVoid vHandleMessage( tU32 /*u32Message*/,
                              tU32 /*u32Parm = 0*/ ){}                       //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tBool bHandleSynchrounousCall( tU32   /*u32Message*/,
                                       tVoid */*args*/ ){ return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vCheckSupervisionState( )   = 0;

virtual tVoid vTriggerSupervisionState( ) = 0;

virtual tVoid vEnableTriggering( ){ _bTriggeringEnabled = TRUE; }
virtual tVoid vDisableTriggering( ){ _bTriggeringEnabled = FALSE; }

virtual tVoid vStopSupervision( ){ _bStopSupervision = TRUE; }
virtual tVoid vStartSupervision( ){ _bStopSupervision = FALSE; }

/*!
  * \fn
  *  \brief
  *        Return the state of Supervision. return the bool.
  *        Enable : true
  *        Disable: false
  ******
  */
virtual tBool bSupervisionEnabled( ) { return _bSupervisionEnabled; }

virtual tVoid vTraceInfo( )              = 0;

virtual tVoid vSetCount( tU32 u32Count ) = 0;

virtual const tChar*getName( ) const     = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmSupervisionClient" ); }
};

