/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CpuLoadSupervisor.h
  * @brief        This is header file contains functions for CPU usage supervision (CpuLoadSupervisor).
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include <map>
#include "spm_LxProcInfo.h"
#include "spm_ISuperVisionClient.h"

/*!
  *  \class spm_tclCpuLoadSupervisor
  *  \brief This class implements the functionality for the CPU usage supervision.
  */
class spm_tclCpuLoadSupervisor : public ISpmSupervisionClient
{
private:
tU32                                          _u32CpuUsageCheckPeriodS;
tBool                                         _bDoApplicationProcessorReset;
tU32                                          _u32ThreadCpuUsagePerCoreThreshold;
OSAL_tMSecond                                 _msCpuUsageRealtimeTimeout;
OSAL_tMSecond                                 _msCpuUsageNiceTimeout;
tLong                                         _lNicePriority;
tLong                                         _lRealtimePriority;
tU32                                          _u32NumberOfCpus;
tSize                                         _siNumberOfProcs;
tSize                                         _siNumberOfThreads;
tU32                                          _u32NumberOfCalculatedProcs;
tU32                                          _u32NumberOfCalculatedThreads;
tU32                                          _u32Duration;
tU32                                          _u32TriggerCount;
tU32                                          _u32CpuUsageSupervisionThread;
tULong                                        _ulPeriodOverallTicksSupervisionThread;
spm_tclLxCpuInfo                              _oCpuInfo;

std::map < tInt, spm_tclLxThreadStatusInfo >  _mapThreadCpuUsageMap;
std::map < tInt, spm_tclLxProcessStatusInfo > _mapProcessCpuUsageMap;

ISpmSupervisionManager                       *_poclSupervisionManager;
ISpmSystemPowerManager                       *_poclSystemPowerManager;
ISpmStartupSupervisor                        *_poclStartupSupervisor;
ISpmOsalProxy                                *_poclOsalProxy;
ISpmSystemLoadStatistics                     *_poclCpuUsageStatistic;

tVoid vCheckCPUUsageOfAllThreads( tULong ulAllCpuCoresPeriodOverallTicks );

public:
spm_tclCpuLoadSupervisor( const ISpmFactory& factory );
virtual ~spm_tclCpuLoadSupervisor( );

// interface functions ISpmBase
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

// interface functions ISpmSupervisionClient
virtual tVoid vCheckSupervisionState( );

virtual tVoid vTriggerSupervisionState( );

virtual tVoid vTraceInfo( );

virtual const tChar*getName( ) const { return( "spm_tclCpuLoadSupervisor" ); }

virtual tVoid        vSetCount( tU32 u32Count ){ _u32TriggerCount = u32Count; }
};

