/*!
  * \file  spm_SubStateHandler_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclSubStateHandler_include_ext: user specific code start
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

// my class header
#include "spm_SubStateHandler.h"
#include "spm_IApplicationDatabase.h"
#include "spm_ISuperVisionClient.h"
// my class header
// my class header
// spm_tclSubStateHandler_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_SubStateHandler_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclSubStateHandler_include_spm: user specific code start
// spm_tclSubStateHandler_include_spm: user specific code end


tVoid spm_tclSubStateHandler::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_GETIGNITIONOFFTIME:
      {

         // GetIgnitionOffTime: user specific code start
         // GetIgnitionOffTime: user specific code end
      }
      break;

      case SPM_GETSIMULATEONTIPPER:
      {

         // GetSimulateOnTipper: user specific code start
         vSetSubStateType(SPM_U32_ON_TIPPER, FALSE);
         // GetSimulateOnTipper: user specific code end
      }
      break;

      case SPM_SETIGNITIONOFFTIME:
      {
         // IgnitionOff time (HourLogic) is set in min.
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SetIgnitionOffTime' was called: param1 = 0x%x", param1 ) );

         // SetIgnitionOffTime: user specific code start
         dp_tclSpmDpConfigIgnitionOffTime oIgnOff;
         oIgnOff.vSetData(param1);
         SPM_GET_CLASS_REFERENCE_NEW_VAR(poclSupervisionClientIgnOff, spm_tclIgnitionOffSupervisor, ISpmSupervisionClient);
         poclSupervisionClientIgnOff->vTriggerSupervisionState();
         // SetIgnitionOffTime: user specific code end
      }
      break;

      case SPM_SPMONOFFREASON:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmOnOffReason' was called: param1 = 0x%x", param1 ) );

         // SpmOnOffReason: user specific code start
         // vSetSubState(param1&0x7fffffff, (param1&0x80000000)?(param1&0x7fffffff):0);
         param1++;
         (tVoid)param1;
         // SpmOnOffReason: user specific code end
      }
      break;

      case SPM_SPMSUBSTATE:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         tU32 param2 = (tU32)((puchData[7]<<24) | (puchData[8]<<16) | (puchData[9]<<8) | puchData[10]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSubState' was called: param1 = 0x%x, param2 = 0x%x", param1, param2 ) );

         // SpmSubState: user specific code start
         // For TTFis commands debounce is set to false (CMG3GB-3449)
         vSetSubStateType(param1, (tBool)param2, FALSE);
         // SpmSubState: user specific code end
      }
      break;

      case SPM_SPMSETWAKEUPCONFIG:
      {
         // Set wakeup configuration 
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetWakeupConfig' was called: param1 = 0x%x", param1 ) );

         // SpmSetWakeupConfig: user specific code start
         ETG_TRACE_USR1( ( "spm_tclSubStateHandler::current configured wakeup triggers" ) );
         vTraceTrigger(SSH_vWakeupTrigger, &_tTriggerWakeup);
         tBool bReturn = bSetWakeupConfig(param1);
         if (bReturn){
            ETG_TRACE_FATAL( ( "spm_tclSubStateHandler::Successfully set the wakeup configuration" ) );
         } else {
            ETG_TRACE_FATAL( ( "spm_tclSubStateHandler::setting wakeup configuration FAILED" ) );
         }
         // SpmSetWakeupConfig: user specific code end
      }
      break;

      case SPM_SPMGETCURRENTWAKEUPCONFIG:
      {
         // Trace out the current configured wakeup.triggers

         // SpmGetCurrentWakeupConfig: user specific code start
            ETG_TRACE_FATAL( ( "spm_tclSubStateHandler::current configured wakeup triggers" ) );
            vTraceTrigger(SSH_vWakeupTrigger, &_tTriggerWakeup, (tU16)TR_LEVEL_FATAL);
         // SpmGetCurrentWakeupConfig: user specific code end
      }
      break;

      case SPM_SPMENABLEPREPARESHUTDOWNTMLTEST:
      {
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmEnablePrepareShutdownTmlTest' was called: param1 = 0x%x", param1 ) );

         // SpmEnablePrepareShutdownTmlTest: user specific code start
         _bIsPrepareShutdownTmlTest = (tBool)param1;
         // SpmEnablePrepareShutdownTmlTest: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclSubStateHandlerFunction: user specific code start
     // spm_tclSubStateHandlerFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclSubStateHandlerFile: user specific code start
// spm_tclSubStateHandlerFile: user specific code end

