/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SubStateDefines.h
  * @brief        generated file containing SubState defines as defined in the fi.
  *               generated at  : 2020
  *               generated with: sysstategenerator.py
  * @copyright    (C) 2012 - 2020 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

/*!
   \def SPM_TRIGGER_ARRAY_SIZE
   Size of the array containing the substattes in bytes == (number of substates)/32 + 1
  */
#define SPM_TRIGGER_ARRAY_SIZE    5

/*!
   \def NO_TRIGGER_TO_CHECK
   defines (depending on SPM_TRIGGER_ARRAY_SIZE a mask for substate handling
  */
#define NO_TRIGGER_TO_CHECK     0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF

/*!
   \struct TTriggerMsg
   structure containing the substates with info about what substates are set (in u32Trigger) and what substate was recently updated in (u32TriggerUpdate)
  */
typedef struct
{
   tU32 u32Trigger[SPM_TRIGGER_ARRAY_SIZE];
   tU32 u32TriggerUpdate[SPM_TRIGGER_ARRAY_SIZE];
} TTriggerMsg;

/*!
   \def SPM_U32_SET_SD_CARD_ACCESS
   SD card write process (ripping) is active/inactive.
  */
#define SPM_U32_SET_SD_CARD_ACCESS                (tU32)0

/*!
   \def SPM_U32_EMERGENCY_OFF
   Shutdown system immediately.
  */
#define SPM_U32_EMERGENCY_OFF                     (tU32)1

/*!
   \def SPM_U32_FAST_SHUTDOWN
   Shutdown system immediately.
  */
#define SPM_U32_FAST_SHUTDOWN                     (tU32)2

/*!
   \def SPM_U32_DIMMING
   Dimming is active/inactive.
  */
#define SPM_U32_DIMMING                           (tU32)3

/*!
   \def SPM_U32_DOWNLOAD
   Download is active/inactive.
  */
#define SPM_U32_DOWNLOAD                          (tU32)4

/*!
   \def SPM_U32_DIAG_ACTIVITY
   Diagnosis activity is active/inactive.
  */
#define SPM_U32_DIAG_ACTIVITY                     (tU32)5

/*!
   \def SPM_U32_DIAGNOSIS
   Diagnosis is active/inactive.
  */
#define SPM_U32_DIAGNOSIS                         (tU32)6

/*!
   \def SPM_U32_PHONE
   BT-Phone is active/inactive.
  */
#define SPM_U32_PHONE                             (tU32)7

/*!
   \def SPM_U32_ACCESSORY
   S-Contact (Accessory) is active/inactive.
  */
#define SPM_U32_ACCESSORY                         (tU32)8

/*!
   \def SPM_U32_IGNITION
   Ignition (Run)is active/inactive.
  */
#define SPM_U32_IGNITION                          (tU32)9

/*!
   \def SPM_U32_TRANSPORTMODE
   Transportmode is active/inactive.
  */
#define SPM_U32_TRANSPORTMODE                     (tU32)10

/*!
   \def SPM_U32_DOOROPEN
   Door is opened.
  */
#define SPM_U32_DOOROPEN                          (tU32)11

/*!
   \def SPM_U32_DOORLOCK
   Door is locked/unlocked.
  */
#define SPM_U32_DOORLOCK                          (tU32)12

/*!
   \def SPM_U32_TRIGGER_FORCE_ON
   Force On (event).
  */
#define SPM_U32_TRIGGER_FORCE_ON                  (tU32)13

/*!
   \def SPM_U32_CLIMATE_INFO
   Climate information is active/inactive.
  */
#define SPM_U32_CLIMATE_INFO                      (tU32)14

/*!
   \def SPM_U32_PARK_DISTANCE_CTRL
   Park distance control is active/inactive.
  */
#define SPM_U32_PARK_DISTANCE_CTRL                (tU32)15

/*!
   \def SPM_U32_FACTORY_MODE
   Factory mode is active/inactive.
  */
#define SPM_U32_FACTORY_MODE                      (tU32)16

/*!
   \def SPM_U32_CD_INSERT
   CD is inserted (event).
  */
#define SPM_U32_CD_INSERT                         (tU32)17

/*!
   \def SPM_U32_SD_INSERT
   SD card is inserted (event).
  */
#define SPM_U32_SD_INSERT                         (tU32)18

/*!
   \def SPM_U32_EJECT
   eject is pressed (event).
  */
#define SPM_U32_EJECT                             (tU32)19

/*!
   \def SPM_U32_ON_TIPPER
   OnTipper is pressed (event).
  */
#define SPM_U32_ON_TIPPER                         (tU32)20

/*!
   \def SPM_U32_SOFTTOP_OPEN
   Softtop is active/inactive.
  */
#define SPM_U32_SOFTTOP_OPEN                      (tU32)21

/*!
   \def SPM_U32_AIRBAG_DEPLOYED
   Airbag deployed (event).
  */
#define SPM_U32_AIRBAG_DEPLOYED                   (tU32)22

/*!
   \def SPM_U32_KEY_PRESENT
   Key is present (active/inactive).
  */
#define SPM_U32_KEY_PRESENT                       (tU32)23

/*!
   \def SPM_U32_NETWORK_ACTIVITY
   Key is present (active/inactive).
  */
#define SPM_U32_NETWORK_ACTIVITY                  (tU32)24

/*!
   \def SPM_U32_OFF_TIPPER
   Key is present (active/inactive).
  */
#define SPM_U32_OFF_TIPPER                        (tU32)25

/*!
   \def SPM_U32_OFF_LASTSTATE_CYCLE
   Trigger cycle current state - OFF - current state.
  */
#define SPM_U32_OFF_LASTSTATE_CYCLE               (tU32)26

/*!
   \def SPM_U32_DIAG_REQUEST
   Diag tester is present (active/inactive).
  */
#define SPM_U32_DIAG_REQUEST                      (tU32)27

/*!
   \def SPM_U32_BACKLIGHT
   Backlight via dimming (active/inactive).
  */
#define SPM_U32_BACKLIGHT                         (tU32)28

/*!
   \def SPM_U32_HIGH_VOLTAGE
   High voltage behaviour detected (active/inactive).
  */
#define SPM_U32_HIGH_VOLTAGE                      (tU32)29

/*!
   \def SPM_U32_RCV_CONNECTED
   Rearview camera connected (active/inactive).
  */
#define SPM_U32_RCV_CONNECTED                     (tU32)30

/*!
   \def SPM_U32_OFF_LEARN
   Set when shutdown should be prohibit by RadioLib (active/inactive).
  */
#define SPM_U32_OFF_LEARN                         (tU32)31

/*!
   \def SPM_U32_HEARTBEAT
   Only for internal SPM use.
  */
#define SPM_U32_HEARTBEAT                         (tU32)32

/*!
   \def SPM_U32_USER_ON_REQ
   Device must stay UserOn.
  */
#define SPM_U32_USER_ON_REQ                       (tU32)33

/*!
   \def SPM_U32_BACKGROUND_ON_REQ
   Device must stay On in the background.
  */
#define SPM_U32_BACKGROUND_ON_REQ                 (tU32)34

/*!
   \def SPM_U32_MULTIMEDIA_ON
   Trigger to switch MultiMedia system ON
  */
#define SPM_U32_MULTIMEDIA_ON                     (tU32)35

/*!
   \def SPM_U32_ANIMATION
   Welcome animation running.
  */
#define SPM_U32_ANIMATION                         (tU32)36

/*!
   \def SPM_U32_MULTIMEDIA_OPERATION
   Trigger to keep MultiMedia system alive.
  */
#define SPM_U32_MULTIMEDIA_OPERATION              (tU32)37

/*!
   \def SPM_U32_TELEMATIC_ACTIVE
   Telematic services are active.
  */
#define SPM_U32_TELEMATIC_ACTIVE                  (tU32)38

/*!
   \def SPM_U32_STANDBY_REQ
   AIVI specific.
  */
#define SPM_U32_STANDBY_REQ                       (tU32)39

/*!
   \def SPM_U32_ACCESSORY_ACTIVE
   deprecated - use SPM_U32_SUBSTATE_S_CONTACT.
  */
#define SPM_U32_ACCESSORY_ACTIVE                  (tU32)40

/*!
   \def SPM_U32_SHUTDOWN_BATTERY_SAVING
   Set when shutdown is requested due to battery problems.
  */
#define SPM_U32_SHUTDOWN_BATTERY_SAVING           (tU32)41

/*!
   \def SPM_U32_TML_REQ_BACKGROUND
   TML Specific (LCM Internal): Currently used by TML for StateMachineTests (to test transitions from BACKGROUND system state).
  */
#define SPM_U32_TML_REQ_BACKGROUND                (tU32)42

/*!
   \def SPM_U32_IGNITION_TIMEOUT
   Only for internal SPM use.
  */
#define SPM_U32_IGNITION_TIMEOUT                  (tU32)43

/*!
   \def SPM_U32_IGNITION_INVALID
   Only for internal SPM use.
  */
#define SPM_U32_IGNITION_INVALID                  (tU32)44

/*!
   \def SPM_U32_FIRST_PIC_DRAWN
   First picture is drawn by HMI. SPM can destroy start-up bitmap.
  */
#define SPM_U32_FIRST_PIC_DRAWN                   (tU32)45

/*!
   \def SPM_U32_OVERTEMP
   Critical high temperature is detected -- Emergency off will be triggered.
  */
#define SPM_U32_OVERTEMP                          (tU32)46

/*!
   \def SPM_U32_LOCK_ACTIVITY
   Only for internal SPM use.
  */
#define SPM_U32_LOCK_ACTIVITY                     (tU32)47

/*!
   \def SPM_U32_SYSSTATE_CHECK
   Only for internal SPM use.
  */
#define SPM_U32_SYSSTATE_CHECK                    (tU32)48

/*!
   \def SPM_U32_CR_TEMPERATURE
   Critical high temperature is detected -- Emergency off will be triggered.
  */
#define SPM_U32_CR_TEMPERATURE                    (tU32)49

/*!
   \def SPM_U32_PUSH_TO_TALK
   PTT - Voice recognition.
  */
#define SPM_U32_PUSH_TO_TALK                      (tU32)50

/*!
   \def SPM_U32_ROUTEGUIDANCE_ACTIVE
   Navigation route guidance is active.
  */
#define SPM_U32_ROUTEGUIDANCE_ACTIVE              (tU32)51

/*!
   \def SPM_U32_HW_IGNITION
   Only for internal SPM use.
  */
#define SPM_U32_HW_IGNITION                       (tU32)52

/*!
   \def SPM_U32_CAN_WAKEUP
   Only for internal SPM use. Nissan specific. Used to enable/disable CAN wakeup at runtime.
  */
#define SPM_U32_CAN_WAKEUP                        (tU32)53

/*!
   \def SPM_U32_DOWNLOAD_PERMISSION
   description for DOWNLOAD_PERMISSION is empty
  */
#define SPM_U32_DOWNLOAD_PERMISSION               (tU32)54

/*!
   \def SPM_U32_IGNITION_LOGIC
   Only for internal SPM use.
  */
#define SPM_U32_IGNITION_LOGIC                    (tU32)55

/*!
   \def SPM_U32_LOW_VOLTAGE
   Only for internal SPM use.
  */
#define SPM_U32_LOW_VOLTAGE                       (tU32)56

/*!
   \def SPM_U32_STATE_DEBOUNCE
   Only for internal SPM use.
  */
#define SPM_U32_STATE_DEBOUNCE                    (tU32)57

/*!
   \def SPM_U32_NETWORK_FAILURE
   Only for internal SPM use.
  */
#define SPM_U32_NETWORK_FAILURE                   (tU32)58

/*!
   \def SPM_U32_STATE_TO
   Only for internal SPM use.
  */
#define SPM_U32_STATE_TO                          (tU32)59

/*!
   \def SPM_U32_DEBUG_WAKEUP
   Only for internal SPM use.
  */
#define SPM_U32_DEBUG_WAKEUP                      (tU32)60

/*!
   \def SPM_U32_AUTOMATIC
   Only for internal SPM use.
  */
#define SPM_U32_AUTOMATIC                         (tU32)61

/*!
   \def SPM_U32_CODE_REQUEST
   Only for internal SPM use.
  */
#define SPM_U32_CODE_REQUEST                      (tU32)62

/*!
   \def SPM_U32_SYNC_SHUTDOWN_ACK
   Linux "sync" is ready. Proceed with shutdown.
  */
#define SPM_U32_SYNC_SHUTDOWN_ACK                 (tU32)63

/*!
   \def SPM_U32_FRIENDLY_USER
   Set if state-machine is configured for friendly user - support of OnTipper.
  */
#define SPM_U32_FRIENDLY_USER                     (tU32)64

/*!
   \def SPM_U32_NISSAN_CMF1
   Set if switch to CMF1 state machine.
  */
#define SPM_U32_NISSAN_CMF1                       (tU32)65

/*!
   \def SPM_U32_PREPARE_SHUTDOWN
   NISSAN LCN2KAI: CMF1 - message via MCAN.
  */
#define SPM_U32_PREPARE_SHUTDOWN                  (tU32)66

/*!
   \def SPM_U32_SHUTDOWN
   NISSAN LCN2KAI: CMF1 - message via MCAN.
  */
#define SPM_U32_SHUTDOWN                          (tU32)67

/*!
   \def SPM_U32_HKEY_PRESSED
   NISSAN LCN2KAI: CMF1 - any hard-key should switch device on.
  */
#define SPM_U32_HKEY_PRESSED                      (tU32)68

/*!
   \def SPM_U32_CD_INSERT_CLAMPS
   CD Insert clamps via GPIO.
  */
#define SPM_U32_CD_INSERT_CLAMPS                  (tU32)69

/*!
   \def SPM_U32_CRITICAL_LOW_VOLTAGE
   Critical low voltage level reached (~5V).
  */
#define SPM_U32_CRITICAL_LOW_VOLTAGE              (tU32)70

/*!
   \def SPM_U32_ENDURING_LOW_VOLTAGE
   Enduring low voltage may lead to an emergency off.
  */
#define SPM_U32_ENDURING_LOW_VOLTAGE              (tU32)71

/*!
   \def SPM_U32_DIAG_FAST_SHUTDOWN
   Fast shutdown triggered by diagnostics.
  */
#define SPM_U32_DIAG_FAST_SHUTDOWN                (tU32)72

/*!
   \def SPM_U32_USING_ACCESSORY
   NISSAN LCN2KAI: CMF1 - message via MCAN.
  */
#define SPM_U32_USING_ACCESSORY                   (tU32)73

/*!
   \def SPM_U32_BACKGROUND_IMM_OFF
   NISSAN LCN2KAI: Need for Audio. Transition from ON - SUSPEND not possible for Audio services. First trigger BACKGROUND and then OFF when reached.
  */
#define SPM_U32_BACKGROUND_IMM_OFF                (tU32)74

/*!
   \def SPM_U32_ROLLER_RIG_MODE
   VW MIB specific.
  */
#define SPM_U32_ROLLER_RIG_MODE                   (tU32)75

/*!
   \def SPM_U32_REMOTE_ON_ACTIVE
   Used by AIVI / VW MIB -- Car started by remote request.
  */
#define SPM_U32_REMOTE_ON_ACTIVE                  (tU32)76

/*!
   \def SPM_U32_ENDURING_CR_VOLTAGE
   Enduring Critical (both low or high) voltage may lead to an emergency off.
  */
#define SPM_U32_ENDURING_CR_VOLTAGE               (tU32)77

/*!
   \def SPM_U32_NORMAL_VOLT
   VW MIB specific.
  */
#define SPM_U32_NORMAL_VOLT                       (tU32)78

/*!
   \def SPM_U32_Q_CRITICAL
   VW MIB specific.
  */
#define SPM_U32_Q_CRITICAL                        (tU32)79

/*!
   \def SPM_U32_TRIGGER_RESET
   VW MIB specific.
  */
#define SPM_U32_TRIGGER_RESET                     (tU32)80

/*!
   \def SPM_U32_CAR_WAKEUP
   VW MIB specific.
  */
#define SPM_U32_CAR_WAKEUP                        (tU32)81

/*!
   \def SPM_U32_PHONE_CONNECTED
   A phone is connected (via Bluetooth/USB).
  */
#define SPM_U32_PHONE_CONNECTED                   (tU32)82

/*!
   \def SPM_U32_CUSTOMER_DOWNLOAD
   EndCustomer is doing a download.
  */
#define SPM_U32_CUSTOMER_DOWNLOAD                 (tU32)83

/*!
   \def SPM_U32_STARTUP
   Only for internal SPM use.
  */
#define SPM_U32_STARTUP                           (tU32)84

/*!
   \def SPM_U32_MOST_OFF
   Only for internal SPM use.
  */
#define SPM_U32_MOST_OFF                          (tU32)85

/*!
   \def SPM_U32_MOST_OFF_ERR
   Only for internal SPM use.
  */
#define SPM_U32_MOST_OFF_ERR                      (tU32)86

/*!
   \def SPM_U32_MOST_WAIT_FOR_SHUTDOWN
   Only for internal SPM use.
  */
#define SPM_U32_MOST_WAIT_FOR_SHUTDOWN            (tU32)87

/*!
   \def SPM_U32_MOST_RBD
   Only for internal SPM use.
  */
#define SPM_U32_MOST_RBD                          (tU32)88

/*!
   \def SPM_U32_MOST_SHUTDOWN_EXECUTE
   Shutdown execute sequence active.
  */
#define SPM_U32_MOST_SHUTDOWN_EXECUTE             (tU32)89

/*!
   \def SPM_U32_MOST_PWR_SWITCH_OFF_DELAY
   Only for internal SPM use.
  */
#define SPM_U32_MOST_PWR_SWITCH_OFF_DELAY         (tU32)90

/*!
   \def SPM_U32_SYSSTATE_NETWORK_FAILED
   Only for internal SPM use.
  */
#define SPM_U32_SYSSTATE_NETWORK_FAILED           (tU32)91

/*!
   \def SPM_U32_SAFE
   Only for internal SPM use.
  */
#define SPM_U32_SAFE                              (tU32)92

/*!
   \def SPM_U32_FSM_SHUTDOWN_FINISHED
   Only for internal SPM use.
  */
#define SPM_U32_FSM_SHUTDOWN_FINISHED             (tU32)93

/*!
   \def SPM_U32_WAIT_FOR_FSM_SHUTDOWN_ACK
   OBSOLETE - Only for internal SPM use.
  */
#define SPM_U32_WAIT_FOR_FSM_SHUTDOWN_ACK         (tU32)94

/*!
   \def SPM_U32_WAIT_FOR_FSM_RESTART_ACK
   OBSOLETE - Only for internal SPM use.
  */
#define SPM_U32_WAIT_FOR_FSM_RESTART_ACK          (tU32)95

/*!
   \def SPM_U32_VALET_MODE
   Only for internal SPM use.
  */
#define SPM_U32_VALET_MODE                        (tU32)96

/*!
   \def SPM_U32_CRANK
   Only for internal SPM use.
  */
#define SPM_U32_CRANK                             (tU32)97

/*!
   \def SPM_U32_EMERGENCY_CALL
   Incoming emergency call.
  */
#define SPM_U32_EMERGENCY_CALL                    (tU32)98

/*!
   \def SPM_U32_LIN
   State of LIN network.
  */
#define SPM_U32_LIN                               (tU32)99

/*!
   \def SPM_U32_CELLNETWORK
   GSM network state.
  */
#define SPM_U32_CELLNETWORK                       (tU32)100

/*!
   \def SPM_U32_EXTERNAL_GPIO
   State of an external GPIO - connected to FAKRA/connector.
  */
#define SPM_U32_EXTERNAL_GPIO                     (tU32)101

/*!
   \def SPM_U32_BLUETOOTH
   Bluetooth chip detected activity.
  */
#define SPM_U32_BLUETOOTH                         (tU32)102

/*!
   \def SPM_U32_UART
   UART chip detected activity.
  */
#define SPM_U32_UART                              (tU32)103

/*!
   \def SPM_U32_USB
   USB chip detected activity / inserted device.
  */
#define SPM_U32_USB                               (tU32)104

/*!
   \def SPM_U32_CRITICAL_HIGH_VOLTAGE
   Critical high voltage level reached (~18V).
  */
#define SPM_U32_CRITICAL_HIGH_VOLTAGE             (tU32)105

/*!
   \def SPM_U32_ENDURING_HIGH_VOLTAGE
   Enduring high voltage may lead to an emergency off.
  */
#define SPM_U32_ENDURING_HIGH_VOLTAGE             (tU32)106

/*!
   \def SPM_U32_OVER_THE_AIR_ACTIVE
   Download of SW via OTA is active.
  */
#define SPM_U32_OVER_THE_AIR_ACTIVE               (tU32)107

/*!
   \def SPM_U32_ENGINE_RUNNING
   Engine running.
  */
#define SPM_U32_ENGINE_RUNNING                    (tU32)108

/*!
   \def SPM_U32_UNBALLAST_SWITCH_OFF
   AIVI specific.
  */
#define SPM_U32_UNBALLAST_SWITCH_OFF              (tU32)109

/*!
   \def SPM_U32_CUSTOMER_FEEDBACK_NEEDED
   AIVI specific.
  */
#define SPM_U32_CUSTOMER_FEEDBACK_NEEDED          (tU32)110

/*!
   \def SPM_U32_SWITCH_OFF_REQUEST
   AIVI specific.
  */
#define SPM_U32_SWITCH_OFF_REQUEST                (tU32)111

/*!
   \def SPM_U32_DARK_SCREEN_REQ
   AIVI specific.
  */
#define SPM_U32_DARK_SCREEN_REQ                   (tU32)112

/*!
   \def SPM_U32_DISPLAY_REQUEST
   AIVI specific.
  */
#define SPM_U32_DISPLAY_REQUEST                   (tU32)113

/*!
   \def SPM_U32_TOUCH_ACTIVITY
   AIVI specific.
  */
#define SPM_U32_TOUCH_ACTIVITY                    (tU32)114

/*!
   \def SPM_U32_STORAGE_MODE
   AIVI specific.
  */
#define SPM_U32_STORAGE_MODE                      (tU32)115

/*!
   \def SPM_U32_ECO_MODE
   PSA RCC Specific: Eco_Mode activation via CAN
  */
#define SPM_U32_ECO_MODE                          (tU32)116

/*!
   \def SPM_U32_ECO_MODE_TIMEOUT
   PSA RCC Specific: Eco_Mode activation via CAN
  */
#define SPM_U32_ECO_MODE_TIMEOUT                  (tU32)117

/*!
   \def SPM_U32_PHONE_ECO_MODE_TIMEOUT
   PSA RCC Specific: Eco_Mode Phone Timeout
  */
#define SPM_U32_PHONE_ECO_MODE_TIMEOUT            (tU32)118

/*!
   \def SPM_U32_PHONE_ECO_MODE_POPUP_TIMEOUT
   PSA RCC Specific: Eco_Mode Phone PTimeout
  */
#define SPM_U32_PHONE_ECO_MODE_POPUP_TIMEOUT      (tU32)119

/*!
   \def SPM_U32_EXTERNAL_SHUTDOWN_REQ
   PSA RCC Specific: External Shutown option
  */
#define SPM_U32_EXTERNAL_SHUTDOWN_REQ             (tU32)120

/*!
   \def SPM_U32_EXTERNAL_SHUTDOWN_CONFIG
   PSA RCC Specific: External Shutown option
  */
#define SPM_U32_EXTERNAL_SHUTDOWN_CONFIG          (tU32)121

/*!
   \def SPM_U32_DEMAND_AUDIO_MUTE
   PSA RCC Specific: DEMAND_AUDIO_MUTE
  */
#define SPM_U32_DEMAND_AUDIO_MUTE                 (tU32)122

/*!
   \def SPM_U32_PERTE_COM
   PSA RCC Specific: Network Error
  */
#define SPM_U32_PERTE_COM                         (tU32)123

/*!
   \def SPM_U32_SHUTDOWN_SCREEN_TIMEOUT
   PSA RCC Specific: Shutdown (Goodbye) Screen timeout
  */
#define SPM_U32_SHUTDOWN_SCREEN_TIMEOUT           (tU32)124

/*!
   \def SPM_U32_OFF_REQUEST
   PSA RCC Specific: Intermidate sub state for Ignition Off and Ontipper press
  */
#define SPM_U32_OFF_REQUEST                       (tU32)125

/*!
   \def SPM_U32_ALERT_MODE
   PSA RCC Specific: Alert Mode Activation / De-Activation
  */
#define SPM_U32_ALERT_MODE                        (tU32)126

/*!
   \def SPM_U32_ECO_MODE_ACTIVATED
   PSA RCC Specific: Eco_Mode activation to trigger the Popup
  */
#define SPM_U32_ECO_MODE_ACTIVATED                (tU32)127

/*!
   \def SPM_U32_SMARTAPP_COMM
   PSA RCC Specific: SmartApp communication Active / De-Active
  */
#define SPM_U32_SMARTAPP_COMM                     (tU32)128

/*!
   \def SPM_U32_PHONE_MUTE
   Phone mute line is active/inactive
  */
#define SPM_U32_PHONE_MUTE                        (tU32)129

/*!
   \def SPM_U32_WAITING
   Waiting flag. Internal use. Use for blocking of transition while waiting
  */
#define SPM_U32_WAITING                           (tU32)130

/*!
   \def SPM_U32_MAPLEARN_ONGOING
   Map data transformation ongoing
  */
#define SPM_U32_MAPLEARN_ONGOING                  (tU32)131

/*!
   \def SPM_U32_SPI_PHONE
   SPI-Phone is active/inactive.
  */
#define SPM_U32_SPI_PHONE                         (tU32)132

/*!
   \def SPM_U32_DMVERITY_CHECK
   DM Verity check is ongoing.
  */
#define SPM_U32_DMVERITY_CHECK                    (tU32)133


#define SPM_BC0_SET_SD_CARD_ACCESS                (tU32)0x00000001
#define SPM_BC0_EMERGENCY_OFF                     (tU32)0x00000002
#define SPM_BC0_FAST_SHUTDOWN                     (tU32)0x00000004
#define SPM_BC0_DIMMING                           (tU32)0x00000008
#define SPM_BC0_DOWNLOAD                          (tU32)0x00000010
#define SPM_BC0_DIAG_ACTIVITY                     (tU32)0x00000020
#define SPM_BC0_DIAGNOSIS                         (tU32)0x00000040
#define SPM_BC0_PHONE                             (tU32)0x00000080
#define SPM_BC0_ACCESSORY                         (tU32)0x00000100
#define SPM_BC0_IGNITION                          (tU32)0x00000200
#define SPM_BC0_TRANSPORTMODE                     (tU32)0x00000400
#define SPM_BC0_DOOROPEN                          (tU32)0x00000800
#define SPM_BC0_DOORLOCK                          (tU32)0x00001000
#define SPM_BC0_TRIGGER_FORCE_ON                  (tU32)0x00002000
#define SPM_BC0_CLIMATE_INFO                      (tU32)0x00004000
#define SPM_BC0_PARK_DISTANCE_CTRL                (tU32)0x00008000
#define SPM_BC0_FACTORY_MODE                      (tU32)0x00010000
#define SPM_BC0_CD_INSERT                         (tU32)0x00020000
#define SPM_BC0_SD_INSERT                         (tU32)0x00040000
#define SPM_BC0_EJECT                             (tU32)0x00080000
#define SPM_BC0_ON_TIPPER                         (tU32)0x00100000
#define SPM_BC0_SOFTTOP_OPEN                      (tU32)0x00200000
#define SPM_BC0_AIRBAG_DEPLOYED                   (tU32)0x00400000
#define SPM_BC0_KEY_PRESENT                       (tU32)0x00800000
#define SPM_BC0_NETWORK_ACTIVITY                  (tU32)0x01000000
#define SPM_BC0_OFF_TIPPER                        (tU32)0x02000000
#define SPM_BC0_OFF_LASTSTATE_CYCLE               (tU32)0x04000000
#define SPM_BC0_DIAG_REQUEST                      (tU32)0x08000000
#define SPM_BC0_BACKLIGHT                         (tU32)0x10000000
#define SPM_BC0_HIGH_VOLTAGE                      (tU32)0x20000000
#define SPM_BC0_RCV_CONNECTED                     (tU32)0x40000000
#define SPM_BC0_OFF_LEARN                         (tU32)0x80000000

#define SPM_BC1_HEARTBEAT                         (tU32)0x00000001
#define SPM_BC1_USER_ON_REQ                       (tU32)0x00000002
#define SPM_BC1_BACKGROUND_ON_REQ                 (tU32)0x00000004
#define SPM_BC1_MULTIMEDIA_ON                     (tU32)0x00000008
#define SPM_BC1_ANIMATION                         (tU32)0x00000010
#define SPM_BC1_MULTIMEDIA_OPERATION              (tU32)0x00000020
#define SPM_BC1_TELEMATIC_ACTIVE                  (tU32)0x00000040
#define SPM_BC1_STANDBY_REQ                       (tU32)0x00000080
#define SPM_BC1_ACCESSORY_ACTIVE                  (tU32)0x00000100
#define SPM_BC1_SHUTDOWN_BATTERY_SAVING           (tU32)0x00000200
#define SPM_BC1_TML_REQ_BACKGROUND                (tU32)0x00000400
#define SPM_BC1_IGNITION_TIMEOUT                  (tU32)0x00000800
#define SPM_BC1_IGNITION_INVALID                  (tU32)0x00001000
#define SPM_BC1_FIRST_PIC_DRAWN                   (tU32)0x00002000
#define SPM_BC1_OVERTEMP                          (tU32)0x00004000
#define SPM_BC1_LOCK_ACTIVITY                     (tU32)0x00008000
#define SPM_BC1_SYSSTATE_CHECK                    (tU32)0x00010000
#define SPM_BC1_CR_TEMPERATURE                    (tU32)0x00020000
#define SPM_BC1_PUSH_TO_TALK                      (tU32)0x00040000
#define SPM_BC1_ROUTEGUIDANCE_ACTIVE              (tU32)0x00080000
#define SPM_BC1_HW_IGNITION                       (tU32)0x00100000
#define SPM_BC1_CAN_WAKEUP                        (tU32)0x00200000
#define SPM_BC1_DOWNLOAD_PERMISSION               (tU32)0x00400000
#define SPM_BC1_IGNITION_LOGIC                    (tU32)0x00800000
#define SPM_BC1_LOW_VOLTAGE                       (tU32)0x01000000
#define SPM_BC1_STATE_DEBOUNCE                    (tU32)0x02000000
#define SPM_BC1_NETWORK_FAILURE                   (tU32)0x04000000
#define SPM_BC1_STATE_TO                          (tU32)0x08000000
#define SPM_BC1_DEBUG_WAKEUP                      (tU32)0x10000000
#define SPM_BC1_AUTOMATIC                         (tU32)0x20000000
#define SPM_BC1_CODE_REQUEST                      (tU32)0x40000000
#define SPM_BC1_SYNC_SHUTDOWN_ACK                 (tU32)0x80000000

#define SPM_BC2_FRIENDLY_USER                     (tU32)0x00000001
#define SPM_BC2_NISSAN_CMF1                       (tU32)0x00000002
#define SPM_BC2_PREPARE_SHUTDOWN                  (tU32)0x00000004
#define SPM_BC2_SHUTDOWN                          (tU32)0x00000008
#define SPM_BC2_HKEY_PRESSED                      (tU32)0x00000010
#define SPM_BC2_CD_INSERT_CLAMPS                  (tU32)0x00000020
#define SPM_BC2_CRITICAL_LOW_VOLTAGE              (tU32)0x00000040
#define SPM_BC2_ENDURING_LOW_VOLTAGE              (tU32)0x00000080
#define SPM_BC2_DIAG_FAST_SHUTDOWN                (tU32)0x00000100
#define SPM_BC2_USING_ACCESSORY                   (tU32)0x00000200
#define SPM_BC2_BACKGROUND_IMM_OFF                (tU32)0x00000400
#define SPM_BC2_ROLLER_RIG_MODE                   (tU32)0x00000800
#define SPM_BC2_REMOTE_ON_ACTIVE                  (tU32)0x00001000
#define SPM_BC2_ENDURING_CR_VOLTAGE               (tU32)0x00002000
#define SPM_BC2_NORMAL_VOLT                       (tU32)0x00004000
#define SPM_BC2_Q_CRITICAL                        (tU32)0x00008000
#define SPM_BC2_TRIGGER_RESET                     (tU32)0x00010000
#define SPM_BC2_CAR_WAKEUP                        (tU32)0x00020000
#define SPM_BC2_PHONE_CONNECTED                   (tU32)0x00040000
#define SPM_BC2_CUSTOMER_DOWNLOAD                 (tU32)0x00080000
#define SPM_BC2_STARTUP                           (tU32)0x00100000
#define SPM_BC2_MOST_OFF                          (tU32)0x00200000
#define SPM_BC2_MOST_OFF_ERR                      (tU32)0x00400000
#define SPM_BC2_MOST_WAIT_FOR_SHUTDOWN            (tU32)0x00800000
#define SPM_BC2_MOST_RBD                          (tU32)0x01000000
#define SPM_BC2_MOST_SHUTDOWN_EXECUTE             (tU32)0x02000000
#define SPM_BC2_MOST_PWR_SWITCH_OFF_DELAY         (tU32)0x04000000
#define SPM_BC2_SYSSTATE_NETWORK_FAILED           (tU32)0x08000000
#define SPM_BC2_SAFE                              (tU32)0x10000000
#define SPM_BC2_FSM_SHUTDOWN_FINISHED             (tU32)0x20000000
#define SPM_BC2_WAIT_FOR_FSM_SHUTDOWN_ACK         (tU32)0x40000000
#define SPM_BC2_WAIT_FOR_FSM_RESTART_ACK          (tU32)0x80000000

#define SPM_BC3_VALET_MODE                        (tU32)0x00000001
#define SPM_BC3_CRANK                             (tU32)0x00000002
#define SPM_BC3_EMERGENCY_CALL                    (tU32)0x00000004
#define SPM_BC3_LIN                               (tU32)0x00000008
#define SPM_BC3_CELLNETWORK                       (tU32)0x00000010
#define SPM_BC3_EXTERNAL_GPIO                     (tU32)0x00000020
#define SPM_BC3_BLUETOOTH                         (tU32)0x00000040
#define SPM_BC3_UART                              (tU32)0x00000080
#define SPM_BC3_USB                               (tU32)0x00000100
#define SPM_BC3_CRITICAL_HIGH_VOLTAGE             (tU32)0x00000200
#define SPM_BC3_ENDURING_HIGH_VOLTAGE             (tU32)0x00000400
#define SPM_BC3_OVER_THE_AIR_ACTIVE               (tU32)0x00000800
#define SPM_BC3_ENGINE_RUNNING                    (tU32)0x00001000
#define SPM_BC3_UNBALLAST_SWITCH_OFF              (tU32)0x00002000
#define SPM_BC3_CUSTOMER_FEEDBACK_NEEDED          (tU32)0x00004000
#define SPM_BC3_SWITCH_OFF_REQUEST                (tU32)0x00008000
#define SPM_BC3_DARK_SCREEN_REQ                   (tU32)0x00010000
#define SPM_BC3_DISPLAY_REQUEST                   (tU32)0x00020000
#define SPM_BC3_TOUCH_ACTIVITY                    (tU32)0x00040000
#define SPM_BC3_STORAGE_MODE                      (tU32)0x00080000
#define SPM_BC3_ECO_MODE                          (tU32)0x00100000
#define SPM_BC3_ECO_MODE_TIMEOUT                  (tU32)0x00200000
#define SPM_BC3_PHONE_ECO_MODE_TIMEOUT            (tU32)0x00400000
#define SPM_BC3_PHONE_ECO_MODE_POPUP_TIMEOUT      (tU32)0x00800000
#define SPM_BC3_EXTERNAL_SHUTDOWN_REQ             (tU32)0x01000000
#define SPM_BC3_EXTERNAL_SHUTDOWN_CONFIG          (tU32)0x02000000
#define SPM_BC3_DEMAND_AUDIO_MUTE                 (tU32)0x04000000
#define SPM_BC3_PERTE_COM                         (tU32)0x08000000
#define SPM_BC3_SHUTDOWN_SCREEN_TIMEOUT           (tU32)0x10000000
#define SPM_BC3_OFF_REQUEST                       (tU32)0x20000000
#define SPM_BC3_ALERT_MODE                        (tU32)0x40000000
#define SPM_BC3_ECO_MODE_ACTIVATED                (tU32)0x80000000

#define SPM_BC4_SMARTAPP_COMM                     (tU32)0x00000001
#define SPM_BC4_PHONE_MUTE                        (tU32)0x00000002
#define SPM_BC4_WAITING                           (tU32)0x00000004
#define SPM_BC4_MAPLEARN_ONGOING                  (tU32)0x00000008
#define SPM_BC4_SPI_PHONE                         (tU32)0x00000010
#define SPM_BC4_DMVERITY_CHECK                    (tU32)0x00000020

