/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISubStateClient.h
  * @brief        This is header file contains interfaces to exchange sub-state events, process system state, trigger and update set,
  *               get start-up reason and set wake up configuration and ignition off time.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_baseClass.h"
#include "spm_IWorkerClient.h"

#include "spm_SubStateDefines.h"

#define SPM_IGNITION_OFF_TIME_SEC          0
#define SPM_IGNITION_OFF_TIME_MINUTE       1

// //////////////////////////////////////////////////////////////////////////////
// Interface to exchange substate events

/*!
  *  \class ISpmSubStateClient
  *  \brief This abstract class provides interfaces to exchange substate events.
          This class also supplies interfaces to process system state, trigger and update set,
        get startup reason and set wake up configuration and ignition off time.
  */
class ISpmSubStateClient : public ISpmWorkerClient
   , public spm_tclActive
{
public:
ISpmSubStateClient( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmSubStateClient( ){ }

// virtual tVoid vSetInternalSubState(tU32 u32SubStateMask, tU32 u32SubStateData) = 0;
// virtual tU32  u32GetInternSubstate() = 0;
virtual tVoid vSetSubStateType( tU32  u32SubStateType,
                                tBool bSubStateData,
                                tBool bDebounced = TRUE )           = 0;

virtual tVoid vTriggerSubStateType( tU32  u32TriggerType,
                                    tBool bTriggerState,
                                    tBool bSetTriggerOnly = FALSE ) = 0;

// virtual tVoid vNewTrigger(tU32 u32TriggerType, tBool bTriggerState);
virtual TTriggerMsg tGetTrigger( )                                  = 0;

virtual tVoid vStartCommunication( )                                = 0;

virtual tVoid vStart( const std::string& strName,
                      tU32               u32Prio,
                      tU32               u32Stack )                 = 0;

virtual tVoid vProcessSystemState( tU32 u32NewSystemState )         = 0;

virtual tBool bIsTriggerSet( tU32 u32TriggerType )                  = 0;

virtual tBool bIsTriggerUpdateSet( tU32 u32TriggerType )            = 0;

virtual tBool bIsFastShutdownActive( ) const                        = 0;

virtual tU32  u32GetStartupOnReason( tBool bResetState = FALSE )    = 0;

virtual tBool bSetWakeupConfig( tU32 u32WakeupConfig )              = 0;

virtual tVoid vHandleMsgQueue( )                                    = 0;

virtual tU32 u32GetIgnitionCycleCount( )                            = 0;

virtual tVoid vRemoveAllTrigger( TTriggerMsg *pTriggerMsg,
                                 tBool        bDataFlags = TRUE,
                                 tBool        bUpdateFlags = TRUE ) = 0;

virtual tVoid vCopyTrigger( TTriggerMsg *pTriggerDstMsg,
                            TTriggerMsg *pTriggerSrcMsg )           = 0;

virtual const tChar*getName( ) const                                = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmSubStateClient" ); }
};

