/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_StringTokenizer.h
  * @brief        This is header file contains functions to convert string input into a stream of tokens.
  * @copyright    (C) 2014 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>
#include <regex>

/*!
  *  \class spm_tclStringTokenizer
  *  \brief This class converts string input into a stream of tokens.
  */
class spm_tclStringTokenizer
{
    typedef std::string::iterator StrIt;
    typedef std::string::value_type StrValType;
    typedef std::regex_iterator<StrIt> RegexStrIt;

public:
    spm_tclStringTokenizer( const std::string& inputString,
                            const std::string& delimiters,
                            tBool isDelimiterKept );
    virtual ~spm_tclStringTokenizer( ){ }

    std::string   oNextToken( );
    tVoid vRestart( );
    // Check whether there is any remained token in the input string or not
    tBool bHasMoreTokens( ) const { return( _currentRegexIterator != RegexStrIt() ); }
    // Check whether the current token is a delimiter or not
    tBool bIsDelimiter( ) const { return( _isDelimiterChar ); }
    // Get the current position in the input string after splitting
    tSize siGetIndex( ) const { return ( _stringIndex ); }

private:
    std::string     _inputString;
    std::string     _delimiters;
    tBool           _isDelimiterKept;
    tSize           _stringIndex;
    tBool           _isDelimiterChar;

    //C++11 Regex
    std::string strHandleSpecialDelimiters() const;
    std::string strBuildRegexString( const std::string& delimiters ) const;
    std::regex _regexObject;
    RegexStrIt _currentRegexIterator;
};
