/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_StartupInvestigation.h
  * @brief        This is header file contains functions to add start-up items and update application items and to set offset value of timer.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <map>
#include <vector>
#include <utility>
#include <string>
#include <algorithm>
#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_IStartupInvestigationServer.h"

struct TStartupTimeItem
{
   TStartupTimeItem( ){ _u32Time = 0; }

   tU32 _u32Time;
};


typedef std::map < ISpmStartupInvestigationServer::tenSpmStartupReq, TStartupTimeItem > TStartupInvestigationTimesMap;

struct TStartupInvestigationItem
{
   tU32 _u32AppId;
   TStartupInvestigationTimesMap _times;
   tU32 _u32RequestedState;
};

// sorted by time
typedef std::vector < TStartupInvestigationItem > TVectorInvestigation;

/*!
  *  \class spm_tclStartupInvestigation
  *  \brief This class gathers all information during startup. It adds startup items, updates application items and traces items.

          The spm_tclFactory object creates an instance of this class. This class used by class spm_tclStartupSystem to add startup items.

  */
class spm_tclStartupInvestigation : public ISpmStartupInvestigationServer
{
public:
spm_tclStartupInvestigation( const std::string& strSemname,
                             const ISpmFactory& factory );
virtual ~spm_tclStartupInvestigation( );

virtual tVoid vStartupPerformed( ){ _bStartupPerformed = TRUE; }

virtual tVoid vAddStartupItem( const spm_tclStartupItem& oStartupItem );

virtual tVoid vUpdateApplicationItem( tU32             u32AppId,
                                      tenSpmStartupReq enReqState,
                                      tU32             u32RequestedState );

virtual tVoid vDump( );

virtual tVoid vDumpShutdownInvestigation( );

virtual tVoid vSetTimerOffset( tU32 u32TmrOffset ){ _u32TmrOffset = u32TmrOffset; }
virtual tVoid vTraceItems( );

public:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

protected:
virtual const tChar*getName( ) const { return( "spm_tclStartupInvestigation" ); }
virtual tVoid vGetReferences( ){}
virtual tVoid vStartCommunication( ){}

virtual tVoid vTraceShutdownItems( );

virtual tVoid vSetShutdownInvestigationActive( tBool bActive ){ _bShutdownInvestActive = bActive; }

private:
OSAL_tSemHandle                            _hSem;
std::string                                _strSemname;
std::multimap < tU32, spm_tclStartupItem > _items;
TVectorInvestigation                       _apps;
tU32                                       _u32TmrOffset;
tBool                                      _bStartupPerformed;
tBool                                      _bShutdownInvestActive;
};

