/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IProcessShutdown.h
  * @brief        This is header file contains interface functions for ProcessShutdown.
  * @copyright    (C) 2014 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_ISpmBase.h"
#include "spm_IWorkerClient.h"

class IProcessShutdown : public spm_tclActiveClient
   , public ISpmWorkerClient
{
public:
IProcessShutdown( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){
}

virtual ~IProcessShutdown( ){
}

virtual const tChar*getInterfaceName( ) const { return( "IProcessShutdown" ); }

virtual tBool bPostStopProcessRequest( const std::string& strProcName,
                                       tU16               u16ID = 0 ) = 0;

virtual tVoid vHandleMsgQueue( )                                      = 0;

virtual tVoid vCheckWaitForSync( )                                    = 0;


};

