/************************************************************************
  * FILE:         spm_WakeupHandler.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION:  Checks wakeup reason at startup .
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date      | Author               | Modification
  * 21.01.14  | CM-AI/EPB2 Kollai    | initial version
  *
  *************************************************************************/

#pragma once

#include "spm_IWakeupHandler.h"

class ISpmFactory;
class ISpmOsalProxy;
class ISpmStatistics;
class ISpmSystemPowerManager;

class spm_tclWakeupHandler : public ISpmWakeupHandler
{
private:
tU8                     _u8StartType;

tU8                     _u8ResetReason;
tU8                     _u8ResetReasonScc;
tU8                     _u8ResetCounter;

tU32                    _u32WakeupReason;
tU32                    _u32OrgWakeupReason; // --> first wakeup reason detected (needed if reset while startup detected)

tBool                   _bIsReset;

ISpmOsalProxy          *_poclOsalProxy;
ISpmStatistics         *_poRstStat;
ISpmSystemPowerManager *_poclSystemPowerManager;

public:
spm_tclWakeupHandler( const ISpmFactory& factory );
virtual ~spm_tclWakeupHandler( );

protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar *puchData );

virtual const tChar*getName( ) const { return( "spm_tclWakeupHandler" ); }
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual tVoid vStartLateCommunication( );

// ISpmWakeupHandler interface functions
virtual tU8  u8GetStartMode( ){ return( _u8StartType ); }
virtual tU32 u32GetWakeupReason( ){ return( _u32WakeupReason ); }

virtual tVoid vSetWakeupConfiguration( tU32 u32ConfigNb );

virtual tBool bIsReset( ){ return( _bIsReset ); }
virtual tU8   u8GetResetCounter( );
virtual tVoid vSetResetCounter( tU8 u8ResetCounter );

virtual tVoid vCheckResetCounter( );

};

