/************************************************************************
  * FILE:         spm_TimerHandler.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION:  Helper class for Timer Handling.
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2018 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date      | Author               | Modification
  * 25.04.18  | CM-CI1/ERN2-E Kollai | initial version
  *
  *************************************************************************/

#pragma once

#include <map>

#include "spm_ITimerHandler.h"

class spm_tclTimerHandler : public ISpmTimerHandler
{
private:
    OSAL_tTimerHandle       _hTimerHdl;
    ISpmWorkerServer *      _poclWorkerServer;

    typedef struct{
        std::string strClientIfName;
        tU32 u32OsalExpireTime;
        tU32 u32CycleTime;
        tU32 u32MessageToSend;
    }TTimerInfo;

    std::map < std::string, TTimerInfo > _mapTimer;

public:
    spm_tclTimerHandler( const ISpmFactory& factory );
    virtual ~spm_tclTimerHandler( );

    // ISpmTimerHandler interface functions
    virtual tVoid vStartTimer(std::string strClientIfName, std::string strTimeName, tU32 u32Intervall, tU32 u32CycleTime, tU32 u32Message);

protected:
    // ISpmBase interface functions
    virtual tVoid vHandleTraceMessage( const tUChar *puchData );

    virtual const tChar*getName( ) const { return( "spm_tclTimerHandler" ); }
    virtual tVoid vGetReferences( );

    virtual tVoid vStartCommunication( );

    // ISpmWorkerClient interface functions
    virtual tVoid vHandleMessage( tU32 /*u32Message*/,
                                  tU32 /*u32Parm = 0*/ );

    virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                           tVoid *args )
                                           {
                                              (void)u32Message;
                                              (void)args;
                                              return( FALSE ); 
                                           } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

    tVoid vCheckTimerTable( );
    static OSAL_tpfCallback vTimerCallback( tVoid *pArg );

};


