/*!
  * \file  spm_SystemPowerManager_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclSystemPowerManager_include_ext: user specific code start

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

// my class header
#include "spm_SystemPowerManager.h"

#include "spm_IOsalProxy.h"
#include "spm_IStartupSupervisor.h"
#include "spm_ISubStateClient.h"
#include "spm_ISuperVisionManager.h"
#include "spm_IProcessSupervision.h"

#include "spm_factory.h"
// my class header
// my class header
// spm_tclSystemPowerManager_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_SystemPowerManager_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclSystemPowerManager_include_spm: user specific code start
// spm_tclSystemPowerManager_include_spm: user specific code end


tVoid spm_tclSystemPowerManager::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_GETSHOWERRMEM:
      {

         // GetShowErrMem: user specific code start
         vShowErrMem();
         // GetShowErrMem: user specific code end
      }
      break;

      case SPM_SPMWRITESTRINGTOERRMEM:
      {
         const tUChar* pStream1 = (const tUChar*)&puchData[3];

         // SpmWriteStringToErrMem: user specific code start
         tU32          u32MsgLen = puchData[0];
         std::string   strBuffer = "########################################################################";

         vWriteErrmem(U16_M_ERRMEM_SPM_ERROR(SPM_U8_ERRMEM_TYPE_STRING), (const tU8*)strBuffer.c_str(), (tU16)strBuffer.length() );
         vWriteErrmem(U16_M_ERRMEM_SPM_ERROR(SPM_U8_ERRMEM_TYPE_STRING), (tU8*)pStream1,                (tU16)( u32MsgLen - ( pStream1 - &puchData[0] ) + 1 ) ); //lint !e1773
                                                                                                                                                                 // Attempt to cast
                                                                                                                                                                 // away const (or
                                                                                                                                                                 // volatile)
         vWriteErrmem(U16_M_ERRMEM_SPM_ERROR(SPM_U8_ERRMEM_TYPE_STRING), (const tU8*)strBuffer.c_str(), (tU16)strBuffer.length() );
         // SpmWriteStringToErrMem: user specific code end
      }
      break;

      case SPM_SPMRESETPROCESSOR:
      {
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmResetProcessor' was called: param1 = 0x%x", param1 ) );

         // SpmResetProcessor: user specific code start
         ETG_TRACE_USR4( ( "resetting \t processor: %d \n", ETG_ENUM(DEV_WUP_u8Processor, param1) ) );
         _poclOsalProxy->bResetProcessor((tU8)param1, DEV_WUP_C_U8_RESET_MODE_UNLOGGED, DEV_WUP_C_U16_RESET_REASON_UNSPECIFIED);
         // SpmResetProcessor: user specific code end
      }
      break;

      case SPM_SPMSHUTDOWN:
      {
         // Calls the ShutdownSystem function of LCM with the specified parameter.
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmShutdown' was called: param1 = 0x%x", param1 ) );

         // SpmShutdown: user specific code start
         ETG_TRACE_USR4( ( "shutting down system \t ShutdownReason: %d \n", ETG_ENUM(SPM_SHUTDOWN, param1) ) );
         (void) _poclOsalProxy->bShutdownSystem(param1);
         // SpmShutdown: user specific code end
      }
      break;

      case SPM_SPMWDTRESETENABLE:
      {
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmWdtResetEnable' was called" ) );

         // SpmWdtResetEnable: user specific code start
         // _bSupervisionResetEnabled = TRUE;
         // SpmWdtResetEnable: user specific code end
      }
      break;

      case SPM_SPMWDTRESETDISABLE:
      {
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmWdtResetDisable' was called" ) );

         // SpmWdtResetDisable: user specific code start
         _bSupervisionResetEnabled = FALSE;
         // SpmWdtResetDisable: user specific code end
      }
      break;

      case SPM_SPMRESETDISABLE:
      {
         // All resets triggered by SPM will be ignored. Only a FATAL trace will be triggered.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmResetDisable' was called" ) );

         // SpmResetDisable: user specific code start
         _bResetEnabled = FALSE;
         // SpmResetDisable: user specific code end
      }
      break;

      case SPM_SPMRESETENABLE:
      {
         // SPM resets enabled. See command 'SpmResetDisable'.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmResetEnable' was called" ) );

         // SpmResetEnable: user specific code start
         _bResetEnabled = TRUE;
         // SpmResetEnable: user specific code end
      }
      break;

      case SPM_SPMTRIGGERWDTDISABLE:
      {
         // SPM stops triggering watchdog. Will lead to a reset.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerWdtDisable' was called" ) );

         // SpmTriggerWdtDisable: user specific code start
         if (_poclSupervisionManager != NULL){
            // start retriggering the processor watchdog
            _poclSupervisionManager->vEnableRetriggerHwWdt(FALSE);
         }
         // SpmTriggerWdtDisable: user specific code end
      }
      break;

      case SPM_SPMTRIGGERWDTENABLE:
      {
         // SPM starts triggering watchdog again. See command 'SpmTriggerWdtDisable'.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerWdtEnable' was called" ) );

         // SpmTriggerWdtEnable: user specific code start
         if (_poclSupervisionManager != NULL){
            // start retriggering the processor watchdog
            _poclSupervisionManager->vEnableRetriggerHwWdt(TRUE);
         }
         // SpmTriggerWdtEnable: user specific code end
      }
      break;

      case SPM_SPMWDTDISABLE:
      {
         // SPM will not start/trigger watchdog at all. Command will be active after restart.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmWdtDisable' was called" ) );

         // SpmWdtDisable: user specific code start
               ETG_TRACE_FATAL( ( "SpmWdtDisable: Disable watchdog by changing registry 'base.reg' --> set 'PROCESS/BASE/SPM/APP_CONFIG/DISABLE_WDT' to '1' !!!" ) );
         //_poclOsalProxy->vDisableWatchdog(TRUE);
         // SpmWdtDisable: user specific code end
      }
      break;

      case SPM_SPMWDTENABLE:
      {
         // SPM starts starting/triggering watchdog again. See command 'SpmWdtDisable'.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmWdtEnable' was called" ) );

         // SpmWdtEnable: user specific code start
               ETG_TRACE_FATAL( ( "SpmWdtDisable: Enable watchdog by changing registry 'base.reg' --> set 'PROCESS/BASE/SPM/APP_CONFIG/DISABLE_WDT' to '0' (or remove key complete) !!!" ) );
         // SpmWdtEnable: user specific code end
      }
      break;

      case SPM_SPMSETSYSTEMCLOCK:
      {
         // Set the system clock. Normally done by VD Clock or VD Sendor (GPS) -> Format 'SpmSetSystemClock H M D M Y'.
         tU8 param1 = puchData[3];
         tU8 param2 = puchData[4];
         tU8 param3 = puchData[5];
         tU8 param4 = puchData[6];
         tU16 param5 = (tU16)((puchData[7]<<8) | puchData[8]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetSystemClock' was called: param1 = 0x%x, param2 = 0x%x, param3 = 0x%x, param4 = 0x%x, param5 = 0x%x", param1, param2, param3, param4, param5 ) );

         // SpmSetSystemClock: user specific code start
         OSAL_trTimeDate rTD;

         rTD.s32Second         = 0;
         rTD.s32Minute         = param2;
         rTD.s32Hour           = param1;
         rTD.s32Day            = param3;
         rTD.s32Month          = param4;
         rTD.s32Year           = param5 - 1900;
         rTD.s32Weekday        = 0;
         rTD.s32Yearday        = 0;
         rTD.s32Daylightsaving = 0;

         if( OSAL_s32ClockSetTime(&rTD) == OSAL_OK ){
            OSAL_trTimeDate rCurTime;
            if (OSAL_s32ClockGetTime(&rCurTime) == OSAL_OK ){
               ETG_TRACE_FATAL( ( "RTC set OSAL clock: %04d-%02d-%02d  %02d:%02d:%02d(UTC)",
                                  rCurTime.s32Year, rCurTime.s32Month, rCurTime.s32Day,
                                  rCurTime.s32Hour, rCurTime.s32Minute, rCurTime.s32Second ) );
            }
         }

         // SpmSetSystemClock: user specific code end
      }
      break;

      case SPM_SPMDIAGRESET:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmDiagReset' was called: param1 = 0x%x", param1 ) );

         // SpmDiagReset: user specific code start
         vSetRestartType(param1);
         // SpmDiagReset: user specific code end
      }
      break;

      case SPM_SPMSTARTTESTTHREAD:
      {
         // Start a thread via OSAL with given priority
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmStartTestThread' was called: param1 = 0x%x", param1 ) );

         // SpmStartTestThread: user specific code start
         vStartMyDummyEndlessThread(param1); // u32Prio
         // SpmStartTestThread: user specific code end
      }
      break;

      case SPM_SPMSTOPTESTTHREAD:
      {
         // Stops the test thread
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmStopTestThread' was called" ) );

         // SpmStopTestThread: user specific code start
         _bTerminateTestThread = TRUE;
         // SpmStopTestThread: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclSystemPowerManagerFunction: user specific code start
     // spm_tclSystemPowerManagerFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclSystemPowerManagerFile: user specific code start
// spm_tclSystemPowerManagerFile: user specific code end

