/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_OsalWupSupervisionErrorWarning.h
  * @brief        This is header file contains functions to check Supervision Error Warning.
  * @copyright    (C) 2017 Robert Bosch Engineering and Business Solutions Vietnam Company
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include <set>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "spm_IWupSupervisionErrorWarning.h"

/*!
  *  \class spm_tclOsalWupOnOffEvents
  *  \brief  Base class to check Supervision Error Warning

  */
class spm_tclOsalWupSupervisionErrorWarning : public ISpmWupSupervisionErrorWarning
{
private:
OSAL_tIODescriptor _hDeviceWupDescr;
OSAL_tEventHandle  _hEventHandle;
OSAL_tThreadID     _hThreadIdWupEvent;


static tVoid vWupWorkerThread( tVoid *pvArg );

public:
spm_tclOsalWupSupervisionErrorWarning( const ISpmFactory& factory );
virtual ~spm_tclOsalWupSupervisionErrorWarning( );
virtual tU8   u8GetSupervisionErrCode();

protected:
virtual tVoid vHandleTraceMessage( const tUChar* /*puchData*/ ){}
virtual const tChar*getName( ) const { return( "spm_tclOsalWupSupervisionErrorWarning" ); }
virtual tVoid vGetReferences( );
virtual tVoid vDumpInfo(tU8 u8ErrorCode);
virtual tVoid vStartCommunication( );
};

