/*!
  * \file  spm_OsLinux_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclOsLinux_include_ext: user specific code start
// my class header
#include "spm_OsLinux.h"
#include <stdlib.h>
#include "spm_rootdaemon.h"
#include "spm_CriticalSection.h"
// my class header
// my class header
// spm_tclOsLinux_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_OsLinux_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclOsLinux_include_spm: user specific code start
// spm_tclOsLinux_include_spm: user specific code end


tVoid spm_tclOsLinux::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SPMSETREDUCTIONLEVEL:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetReductionLevel' was called: param1 = 0x%x", param1 ) );

         // SpmSetReductionLevel: user specific code start
         (tVoid)bSetReductionLevel(param1);
         // SpmSetReductionLevel: user specific code end
      }
      break;

      case SPM_SPMLXGETTHREADINFO:
      {
         // Show thread/task related information. Parameter 1 = Thread/task name
         const tChar* pString1 = (const tChar*)&puchData[3];

         // SpmLxGetThreadInfo: user specific code start
         (tVoid)bGetThreadInfo(pString1);
         // SpmLxGetThreadInfo: user specific code end
      }
      break;

      case SPM_SPMLXGETRUNNINGTHREADS:
      {
         // Show threads/tasks which are currently in 'running' state.

         // SpmLxGetRunningThreads: user specific code start
         (tVoid)bGetReadyThreads();
         // SpmLxGetRunningThreads: user specific code end
      }
      break;

      case SPM_SPMLXTIMETRACER:
      {

         // SpmLxTimeTracer: user specific code start
         (tVoid)bTriggerTimeTracker();
         // SpmLxTimeTracer: user specific code end
      }
      break;

      case SPM_SPMLXGETPROCINFOBYNAME:
      {
         // Show process related information. Parameter 1 = Process name (OSAL) or systemd start script name (SYSTEMD). Parameter 2 = Process start-type with "OSAL" or "SYSTEMD"
         const tChar* pString1 = (const tChar*)&puchData[3];
         const tChar* pString2 = (const tChar*)&puchData[67];

         // SpmLxGetProcInfoByName: user specific code start
         (tVoid)bGetProcessInfo(pString1, TRUE, pString2);
         // SpmLxGetProcInfoByName: user specific code end
      }
      break;

      case SPM_SPMLXGETPROCINFOBYID:
      {
         // Show process related information. Parameter = Process ID.
         const tChar* pString1 = (const tChar*)&puchData[3];

         // SpmLxGetProcInfoById: user specific code start
         (tVoid)bGetProcessInfo( (tU32)( atoi(pString1) ), TRUE);
         // SpmLxGetProcInfoById: user specific code end
      }
      break;

      case SPM_SPMLXEMTRACEENTRY:
      {
         const tChar* pString1 = (const tChar*)&puchData[3];

         // SpmLxEmTraceEntry: user specific code start
         (tVoid)bEmTraceEntry(pString1);
         // SpmLxEmTraceEntry: user specific code end
      }
      break;

      case SPM_SPMLXADDPROC2SUPERVISION:
      {
         const tChar* pString1 = (const tChar*)&puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmLxAddProc2Supervision' was called: param1 = '%20s'", (const tChar*)pString1 ) );

         // SpmLxAddProc2Supervision: user specific code start
         (tVoid)s32StartProcess(pString1, 3);
         // SpmLxAddProc2Supervision: user specific code end
      }
      break;

      case SPM_SPMLXGETCURRENTPROCESSES:
      {
         // Get a list of the current processes and store the result in the error memory.

         // SpmLxGetCurrentProcesses: user specific code start
         (tVoid)SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", GET_CURRENT_PROCESSES, "");
         // SpmLxGetCurrentProcesses: user specific code end
      }
      break;

      case SPM_SPMTESTBLOCKEDMAINTHREAD:
      {
         // Test to simulate blocked main thread in LCM.

         // SpmTestBlockedMainThread: user specific code start
         OSAL_tSemHandle  _hSpmTestBlockedThread(OSAL_C_INVALID_HANDLE);
         if ( OSAL_ERROR != OSAL_s32SemaphoreCreate( "SpmTestBlockedThread", &_hSpmTestBlockedThread, (tU32)1 ) ){
            ETG_TRACE_ERRMEM( ( "SPM command SpmTestBlockedThread was called") );
            // When we call spm_vEnterCritical twice time with the same Semaphore-ID of thread SpmTestBlockedThread
            // Then this thread is deadlocked as each are waiting for the other.
            spm_vEnterCritical( _hSpmTestBlockedThread );
            spm_vEnterCritical( _hSpmTestBlockedThread );
         }
         else {
            tU32 u32ErrorReason = OSAL_u32ErrorCode( );
            ETG_TRACE_ERRMEM( ( "SPM: SpmTestBlockedThread !!!!!! Error detected !!!!!! cannot create Semaphore _hSpmTestBlockedThread: error 0x%08X (%s)",
                              (tUInt)u32ErrorReason, OSAL_coszErrorText( u32ErrorReason ) ) );
            ETG_TRACE_ERRMEM( ( "SPM command SpmTestBlockedThread was not executed") );
         }
         // SpmTestBlockedMainThread: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_TRIGGER_TIME_TRACKER:
      {
         // Trigger root daemon command TRIGGER_TIME_TRACKER for TML test purposes. Parameter = "processes" or any other string to consider processes or threads for the resulting PS shell command.
         const tChar* pString1 = (const tChar*)&puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmRootDaemonCommand_TRIGGER_TIME_TRACKER' was called: param1 = '%20s'", (const tChar*)pString1 ) );

         // SpmRootDaemonCommand_TRIGGER_TIME_TRACKER: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_TRIGGER_TIME_TRACKER with parameter '%s'", pString1 ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", TRIGGER_TIME_TRACKER, pString1);
         ETG_TRACE_FATAL( ( "TRIGGER_TIME_TRACKER_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_TRIGGER_TIME_TRACKER: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_GET_RUNNING_THREADS:
      {
         // Trigger root daemon command GET_RUNNING_THREADS for TML test purposes.

         // SpmRootDaemonCommand_GET_RUNNING_THREADS: user specific code start
         CmdData rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_GET_RUNNING_THREADS" ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", GET_RUNNING_THREADS, "");
         ETG_TRACE_FATAL( ( "GET_RUNNING_THREADS_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_GET_RUNNING_THREADS: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_GET_THREAD_INFO:
      {
         // Trigger root daemon command GET_THREAD_INFO for TML test purposes. Parameter = Name of the thread.
         const tChar* pString1 = (const tChar*)&puchData[3];

         // SpmRootDaemonCommand_GET_THREAD_INFO: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_GET_THREAD_INFO with parameter '%s'", pString1 ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", GET_THREAD_INFO, pString1);
         ETG_TRACE_FATAL( ( "GET_THREAD_INFO_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_GET_THREAD_INFO: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_GET_PROCESS_INFO_BY_NAME:
      {
         // Trigger root daemon command GET_PROCESS_INFO_BY_NAME for TML test purposes. Parameter = Name of the process (OSAL) or name of the service-script (SYSTEMD).
         const tChar* pString1 = (const tChar*)&puchData[3];

         // SpmRootDaemonCommand_GET_PROCESS_INFO_BY_NAME: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_GET_PROCESS_INFO_BY_NAME with parameter '%s'", pString1 ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", GET_PROCESS_INFO_BY_NAME, pString1);
         ETG_TRACE_FATAL( ( "GET_PROCESS_INFO_BY_NAME_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_GET_PROCESS_INFO_BY_NAME: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_GET_PROCESS_INFO_BY_ID:
      {
         // Trigger root daemon command GET_PROCESS_INFO_BY_ID for TML test purposes. Parameter = ID of the process.
         const tChar* pString1 = (const tChar*)&puchData[3];

         // SpmRootDaemonCommand_GET_PROCESS_INFO_BY_ID: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_GET_PROCESS_INFO_BY_ID with parameter '%s'", pString1 ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", GET_PROCESS_INFO_BY_ID, pString1);
         ETG_TRACE_FATAL( ( "GET_PROCESS_INFO_BY_ID_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_GET_PROCESS_INFO_BY_ID: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_SEND_SIGNAL_TO_PROCESS_VIA_SYSTEMD:
      {
         // Trigger root daemon command SEND_SIGNAL_TO_PROCESS_VIA_SYSTEMD for TML test purposes. Parameter 1 = Name of the signal, Parameter 2 = Name of the service-script.
         const tChar* pString1 = (const tChar*)&puchData[3];
         const tChar* pString2 = (const tChar*)&puchData[67];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmRootDaemonCommand_SEND_SIGNAL_TO_PROCESS_VIA_SYSTEMD' was called: param1 = '%20s', param2 = '%20s'", (const char*)pString1, (const char*)pString2 ) );

         // SpmRootDaemonCommand_SEND_SIGNAL_TO_PROCESS_VIA_SYSTEMD: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         std::string  parameters = pString1;
         parameters += " ";
         parameters += pString2;
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_SEND_SIGNAL_TO_PROCESS_VIA_SYSTEMD with parameter '%s'", parameters.c_str() ) );
         rCmdData    = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", SEND_SIGNAL_TO_PROCESS_VIA_SYSTEMD, parameters.c_str() );
         ETG_TRACE_FATAL( ( "SEND_SIGNAL_TO_PROCESS_VIA_SYSTEMD_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_SEND_SIGNAL_TO_PROCESS_VIA_SYSTEMD: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_SEND_SIGNAL_TO_PROCESS:
      {
         // Trigger root daemon command SEND_SIGNAL_TO_PROCESS for TML test purposes. Parameter 1 = Number of the signal, Parameter 2 = Name of the process.
         const tChar* pString1 = (const tChar*)&puchData[3];
         const tChar* pString2 = (const tChar*)&puchData[67];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmRootDaemonCommand_SEND_SIGNAL_TO_PROCESS' was called: param1 = '%20s', param2 = '%20s'", (const tChar*)pString1, (const tChar*)pString2 ) );

         // SpmRootDaemonCommand_SEND_SIGNAL_TO_PROCESS: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         std::string  parameters = pString1;
         parameters += " ";
         parameters += pString2;
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_SEND_SIGNAL_TO_PROCESS with parameter '%s'", parameters.c_str() ) );
         rCmdData    = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", SEND_SIGNAL_TO_PROCESS, parameters.c_str() );
         ETG_TRACE_FATAL( ( "SEND_SIGNAL_TO_PROCESS_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_SEND_SIGNAL_TO_PROCESS: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_SEND_SIGNAL_TO_ALL_PROCESSES:
      {
         // Trigger root daemon command SEND_SIGNAL_TO_ALL_PROCESSES for TML test purposes. Parameter 1 = Number of the signal, Parameter 2 = Name of the process.
         const tChar* pString1 = (const tChar*)&puchData[3];
         const tChar* pString2 = (const tChar*)&puchData[67];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmRootDaemonCommand_SEND_SIGNAL_TO_ALL_PROCESSES' was called: param1 = '%20s', param2 = '%20s'", (const tChar*)pString1, (const tChar*)pString2 ) );

         // SpmRootDaemonCommand_SEND_SIGNAL_TO_ALL_PROCESSES: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         std::string  parameters = pString1;
         parameters += " ";
         parameters += pString2;
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_SEND_SIGNAL_TO_ALL_PROCESSES with parameter '%s'", parameters.c_str() ) );
         rCmdData    = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", SEND_SIGNAL_TO_ALL_PROCESSES, parameters.c_str() );
         ETG_TRACE_FATAL( ( "SEND_SIGNAL_TO_ALL_PROCESSES_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_SEND_SIGNAL_TO_ALL_PROCESSES: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_GET_PROCESS_HIGH_WATER_MARKS:
      {
         // Trigger root daemon command GET_PROCESS_HIGH_WATER_MARKS for TML test purposes. Parameter = Location of the XML configuration file.
         const tChar* pString1 = (const tChar*)&puchData[3];

         // SpmRootDaemonCommand_GET_PROCESS_HIGH_WATER_MARKS: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_GET_PROCESS_HIGH_WATER_MARKS with parameter '%s'", pString1 ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", GET_PROCESS_HIGH_WATER_MARKS, pString1);
         ETG_TRACE_FATAL( ( "GET_PROCESS_HIGH_WATER_MARKS_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_GET_PROCESS_HIGH_WATER_MARKS: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_UNMOUNT_PARTITIONS:
      {
         // Trigger root daemon command UNMOUNT_PARTITIONS for TML test purposes.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmRootDaemonCommand_UNMOUNT_PARTITIONS' was called" ) );

         // SpmRootDaemonCommand_UNMOUNT_PARTITIONS: user specific code start

         // Open or create a file to have a handle from this process open at the time
         // the UNMOUNT.PY script is called via the root daemon. The UNMOUNT.PY should
         // then detect this process as one that still has open files handles and
         // print the process name and its process ID to the error memory.

         // The trace output "TML RESULT = %d %d" is used by the TML test
         // "SPM_RootDaemonCommand_UNMOUNT_PARTITIONS.tml" to verify the success of
         // the UNMOUNT.PY script and it contains two parameters. The first parameter is
         // the result of the script (0 or 1) and the second parameter is the ID of THIS
         // process and which is a process with an open file handle.

         // The TML test "SPM_RootDaemonCommand_UNMOUNT_PARTITIONS.tml" then performs
         // the following actions to verify the success of the execution of the
         // UNMOUNT.PY script :

         // - erase the error memory via the TTFIS command "EM_ERASE"
         // - execute the TTFIS command 'SpmRootDaemonCommand_UNMOUNT_PARTITIONS'
         // - catch the result trace "TML RESULT = %d %d" to know about the result of the script execution and the process ID with the open file handle
         // - verify the result (0 = success, other than 0 = failure) of the execution of the UNMOUNT.PY script
         // - store the passed process ID in a local variable for later use
         // - reboot the target
         // - wait until the system is up again by checking if a TTFIS connection can be established
         // - trigger an output of the error memory via the TTFIS command "EM_TRACE"
         // - check the TTFIS output of the error memory and look for a string "process ID   = #ID"
         // - verify if the #ID matches the process ID from the result trace of the TTFIS command SpmRootDaemonCommand_UNMOUNT_PARTITIONS

         CmdData rCmdData = { 0,0,0,0,0 };
         tCString coszFilename = "/dev/root/var/opt/bosch/persistent/lcm_unmount_test.txt";

         OSAL_trProcessControlBlock rProcessControlBlock;

         OSAL_s32ProcessControlBlock(OSAL_ProcessWhoAmI(), &rProcessControlBlock);

         OSAL_tIODescriptor fd = OSAL_IOOpen( coszFilename, OSAL_EN_READONLY );

         if ( (fd == OSAL_ERROR) && (OSAL_u32ErrorCode() == OSAL_E_DOESNOTEXIST) ){
            fd = OSAL_IOCreate( coszFilename, OSAL_EN_READONLY );
         }

         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_UNMOUNT_PARTITIONS" ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", UNMOUNT_PARTITIONS, "/dev/mmcblk");
         ETG_TRACE_FATAL( ( "UNMOUNT_PARTITIONS_TML_RESULT = %d %d", atoi(rCmdData.message), rProcessControlBlock.id ) );

         // Give the rootdaemon some time to perform the UNMOUNT_PARTITIONS actions before we
         // again close the file handle which should cause an entry into the error memory.
         OSAL_s32ThreadWait( 2000 );

         if (fd != OSAL_ERROR){
            (tVoid)OSAL_s32IOClose( fd );
         }

         // SpmRootDaemonCommand_UNMOUNT_PARTITIONS: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_GET_CURRENT_PROCESSES:
      {
         // Trigger root daemon command GET_CURRENT_PROCESSES for TML test purposes.

         // SpmRootDaemonCommand_GET_CURRENT_PROCESSES: user specific code start
         CmdData rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_GET_CURRENT_PROCESSES" ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", GET_CURRENT_PROCESSES, "");
         ETG_TRACE_FATAL( ( "GET_CURRENT_PROCESSES_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_GET_CURRENT_PROCESSES: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_GET_OOM_INFO:
      {
         // Trigger root daemon command GET_OOM_INFOS for TML test purposes.

         // SpmRootDaemonCommand_GET_OOM_INFO: user specific code start
         CmdData rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_GET_OOM_INFO" ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", GET_OOM_INFO, "");
         ETG_TRACE_FATAL( ( "GET_OOM_INFO_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_GET_OOM_INFO: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_KILL_PROCESS:
      {
         // Trigger root daemon command KILL_PROCESS for TML test purposes. Parameter = Name of the process.
         const tChar* pString1 = (const tChar*)&puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmRootDaemonCommand_KILL_PROCESS' was called: param1 = '%20s'", (const tChar*)pString1 ) );

         // SpmRootDaemonCommand_KILL_PROCESS: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_KILL_PROCESS with parameter '%s'", pString1 ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", KILL_PROCESS, pString1);
         ETG_TRACE_FATAL( ( "KILL_PROCESS_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_KILL_PROCESS: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_SYSTEMCTL_START_UNIT:
      {
         // Trigger root daemon command SYSTEMCTL_START_UNIT for TML test purposes. Parameter = Name of the service-script.
         const tChar* pString1 = (const tChar*)&puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmRootDaemonCommand_SYSTEMCTL_START_UNIT' was called: param1 = '%20s'", (const tChar*)pString1 ) );

         // SpmRootDaemonCommand_SYSTEMCTL_START_UNIT: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_SYSTEMCTL_START_UNIT with parameter '%s'", pString1 ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", SYSTEMCTL_START_UNIT, pString1);
         ETG_TRACE_FATAL( ( "SYSTEMCTL_START_UNIT_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_SYSTEMCTL_START_UNIT: user specific code end
      }
      break;

      case SPM_SPMROOTDAEMONCOMMAND_SYSTEMCTL_STOP_UNIT:
      {
         // Trigger root daemon command SYSTEMCTL_STOP_UNIT for TML test purposes. Parameter = Name of the service-script
         const tChar* pString1 = (const tChar*)&puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmRootDaemonCommand_SYSTEMCTL_STOP_UNIT' was called: param1 = '%20s'", (const tChar*)pString1 ) );

         // SpmRootDaemonCommand_SYSTEMCTL_STOP_UNIT: user specific code start
         CmdData      rCmdData = { 0,0,0,0,0 };
         ETG_TRACE_FATAL( ( "SpmRootDaemonCommand_SYSTEMCTL_STOP_UNIT with parameter '%s'", pString1 ) );
         rCmdData = SPM_ROOTDAEMON_CALLER_rPerformRootOp("lcm", SYSTEMCTL_STOP_UNIT, pString1);
         ETG_TRACE_FATAL( ( "SYSTEMCTL_STOP_UNIT_TML_RESULT = %d", atoi(rCmdData.message) ) );
         // SpmRootDaemonCommand_SYSTEMCTL_STOP_UNIT: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclOsLinuxFunction: user specific code start
     // spm_tclOsLinuxFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclOsLinuxFile: user specific code start
// spm_tclOsLinuxFile: user specific code end

