/************************************************************************
  * FILE:         spm_IWupOnOffEvents.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION: Definition of interfaces used to check OnOffStates, OnOffEvents status
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date        | Author                           | Modification
  * 02.12.2013  | PJ-VW32 Klaus-Peter Kollai       | initial version
  *
  *************************************************************************/


#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_baseClass.h"
#include "spm_ISpmBase.h"

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes
class ISpmWupOnOffEvents : public ISpmBase
{
public:
ISpmWupOnOffEvents( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmWupOnOffEvents( ){}

virtual const tChar*getInterfaceName( ) const { return( "ISpmWupOnOffEvents" ); }

virtual tBool bIsOnOffStateActive( tU32 u32SubState ) = 0;
virtual tVoid vDisableSubState(tU32 u32SubState, tBool bDisable = TRUE) = 0;
};

