/*****************************************************************************
 * FILE:         spm_ISpmOsalCvm.h
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * DESCRIPTION:  interfaces to handle user voltage level handling.
 *
 * ---------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2013 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author               | Modification
 * 21.09.13  | CM-AI/PJVW32 Kollai  | initial version
 *
 *****************************************************************************/
#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

//Hysterisis for Board Voltage Notification in Milli Volts
#define DEV_VOLT_CONF_C_U16_BOARD_VOLTAGE_HYSTERISIS_MV                      200

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_ISpmBase.h"
#include "spm_IFactory.h"

class ISpmCvmUserClient;

class ISpmOsalCvm : public ISpmBase
{
public:
ISpmOsalCvm( const ISpmFactory& factory ) : ISpmBase( factory ){
}

virtual ~ISpmOsalCvm( ){
}

virtual tBool bAddUserVoltClient( ISpmCvmUserClient *client,
                                  tU16               u16VoltageLevel,
                                  tU16               u16Hysteresis = DEV_VOLT_CONF_C_U16_BOARD_VOLTAGE_HYSTERISIS_MV ) = 0;

virtual tBool bRemoveUserVoltClient( ISpmCvmUserClient *client )                                                       = 0;

virtual const tChar*getName( ) const                                                                                   = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmOsalCvm" ); }
};

