/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IOsLinux.h
  * @brief        This is header file contains interfaces to Linux abstraction functions. It also handles system halt and reboot.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ISpmBase.h"
#include "spm_IStartupCommon.h" //to get SPM_STARTUP_VALUE_OSAL_START_TYPE

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes

/*!
  *  \class ISpmOsLinux
  *  \brief This abstract class provides interfaces to handle process related operations. It also handles system halt and reboot.
          This class supplies pure virtual functions to set reduction level and supervision action.
  */
class ISpmOsLinux : public ISpmBase
{
public:
ISpmOsLinux( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmOsLinux( ){}

virtual tBool bSystemHalt( tVoid )         = 0;
virtual tBool bSystemReboot( tVoid )       = 0;

virtual tBool bSupervisionWarning( tVoid ) = 0;
virtual tBool bSupervisionReset( tVoid )   = 0;

virtual tBool bReniceProcess( const std::string& strProcessName )                                    = 0;

virtual tBool bSetReductionLevel( tU32 u32Level )                                                    = 0;

virtual tBool bSetSupervision( tU32 u32Action )                                                      = 0;

virtual tBool bTriggerTimeTracker( tBool bProcesses = FALSE )                                        = 0;

virtual tBool bGetReadyThreads( tVoid ) = 0;
virtual tBool bGetThreadInfo( const std::string& strThreadName )                                     = 0;

virtual tBool bGetProcessInfo( const std::string& strProcessName,
                               tBool              bDumpCallstacks = TRUE,
                               const std::string& strStartType = SPM_STARTUP_VALUE_OSAL_START_TYPE ) = 0;

virtual tBool bGetProcessInfo( tU32  u32ProcdId,
                               tBool bDumpCallstacks = TRUE )                                        = 0;

virtual tBool bEmTraceEntry( const std::string& strEntry )                                           = 0;

virtual tBool bTriggerExceptionHandler( tS32        pid,
                                        std::string message )                                        = 0;

virtual tBool bStopProcess( const std::string& strLocation,
                            const std::string& strShEvent,
                            tU32               u32ProcId = 0 )                                       = 0;

virtual tS32  s32StartProcess( const std::string& strLocation,
                               tU32               u32Type,
                               tU32               u32NiceLevel = 0,
                               tU32               u32NiceLevelEnd = 0,
                               tU32               u32Prio = 0,
                               tU32               u32Affinity = 0,
                               tU32               u32AffinityEnd = 0 ) = 0;

virtual tBool bSyncFilesystem( tU32 u32Timeout )                       = 0;

virtual tBool bShutdown( tU32 u32Timeout )                             = 0;

virtual tBool bStartupFinished( ){ return( FALSE ); }

virtual tBool bWaitForSrv( tU32 u32Timeout )                           = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmOsLinux" ); }

virtual tS32  s32ReadFileContent( const std::string& strFile,
                                  std::string      & strBuf,
                                  tU32               u32Len ) = 0;

virtual tBool bIsFileInFs( const std::string& strFile )       = 0;

virtual tBool bMkDir( const std::string& strFile )            = 0;

virtual tVoid vRunCommandLine( const std::string strCmdLine ) = 0;

};

