/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISpmBase.h
  * @brief        This is header file contains interfaces to get interface name and handle trace messages.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

class ISpmFactory;

// //////////////////////////////////////////////////////////////////////////////
// Base class for all SPM Classes

/*!
  *  \class ISpmBase
  *  \brief This abstract class provides interfaces to get interface name and handle trace messages.
  */
class ISpmBase
{
protected:
const ISpmFactory& _crfFactory;

public:
ISpmBase( const ISpmFactory& factory ) : _crfFactory( factory ){ }
virtual ~ISpmBase( ){ }
virtual tVoid vHandleTraceMessage( const tUChar *puchData ) = 0;

virtual const tChar*getName( ) const                        = 0;

virtual const tChar*getInterfaceName( ) const               = 0;

virtual tVoid vGetReferences( )                             = 0;

virtual tVoid vStartCommunication( )                        = 0;

virtual tVoid vStartLateCommunication( ){}

};

