/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         timeConvert.h
  * @brief        This is header file contains helper functions for time Conversion.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define TIMECONV_U16_TIME_BASE_YEAR      (tU16)(2012)
#define TIMECONV_U32_SECONDS_PER_MINUTE  (tU32)(60)
#define TIMECONV_U32_SECONDS_PER_HOUR    (tU32)( 60 * TIMECONV_U32_SECONDS_PER_MINUTE )
#define TIMECONV_U32_SECONDS_PER_DAY     (tU32)( 24 * TIMECONV_U32_SECONDS_PER_HOUR )
#define TIMECONV_U32_SECONDS_PER_YEAR    (tU32)( 365 * TIMECONV_U32_SECONDS_PER_DAY )

/*!
  *  \class tclTimeConvert
  *  \brief This class gets date from elapsed seconds taking TIMECONV_U16_TIME_BASE_YEAR as base date time .
           It also converts time into seconds considering difference between current date time and base time date.

  */
class tclTimeConvert
{
public:
tclTimeConvert( );
virtual ~tclTimeConvert( ){}

tU32 u32GetSeconds( OSAL_trTimeDate *pTimeDate,
                    tU16             u16TimeDateBase = TIMECONV_U16_TIME_BASE_YEAR ) const;

tVoid vGetDateFromElapsedSeconds( tU32             u32ElapsedSeconds,
                                  OSAL_trTimeDate *pTimeDate,
                                  tU16             u16TimeDateBase = TIMECONV_U16_TIME_BASE_YEAR ) const;

private:
tU8 u8DaysPerMonth( tU8  u8Month,
                    tS16 s16Year ) const;

tBool bIsLeapYear( tS16 s16Year ) const;

};

