/*!
  * \file timeConvert.cpp
  *  \brief
  *        Handles time related calculation
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author                | Modification
  * 22.06.12  | CM-AI/PJ-CB32 Kollai  | initial version
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "timeConvert.h"

tclTimeConvert::tclTimeConvert( ){
}

tBool tclTimeConvert::bIsLeapYear( tS16 s16Year ) const {
   if ( ( ( s16Year % 4 ) == 0 ) && ( ( ( s16Year % 100 ) != 0 ) || ( ( s16Year % 400 ) == 0 ) ) ){
      return( TRUE );
   } else {
      return( FALSE );
   }
}

tU8 tclTimeConvert::u8DaysPerMonth( tU8  u8Month,
                                    tS16 s16Year ) const {
   switch ( u8Month ){
      case 1:
      case 3:
      case 5:
      case 7:
      case 8:
      case 10:
      case 12:
      {
         return( 31 );
      }

      case 4:
      case 6:
      case 9:
      case 11:
      {
         return( 30 );
      }

      case 2:
      {
         if ( bIsLeapYear( s16Year ) ){
            return( 29 );
         } else {
            return( 28 );
         }
      }

      default:
      {
         return( 0 );
      }
   } // switch
}    // u8DaysPerMonth

tU32 tclTimeConvert::u32GetSeconds( OSAL_trTimeDate *pTimeDate,
                                    tU16             u16TimeDateBase ) const {

   tU32 u32Seconds = 0;

   if ( u16TimeDateBase < (tU16)pTimeDate->s32Year ){
      tS16 sYear = (tS16)u16TimeDateBase;

      while ( sYear < (tS16)pTimeDate->s32Year ){
         u32Seconds += TIMECONV_U32_SECONDS_PER_YEAR;
         if ( bIsLeapYear( sYear ) ){
            // add one day for every leap year
            u32Seconds += TIMECONV_U32_SECONDS_PER_DAY;
         }
         sYear++;
      }
      tU8 u8Month = 1; // january
      // and now calculate this month
      while ( u8Month < pTimeDate->s32Month ){
         u32Seconds += ( TIMECONV_U32_SECONDS_PER_DAY * u8DaysPerMonth( u8Month, sYear ) );
         u8Month++;
      }

      u32Seconds += ( TIMECONV_U32_SECONDS_PER_DAY * ( pTimeDate->s32Day - 1 ) ); // without current day
      u32Seconds += ( TIMECONV_U32_SECONDS_PER_HOUR * pTimeDate->s32Hour );
      u32Seconds += ( TIMECONV_U32_SECONDS_PER_MINUTE * ( pTimeDate->s32Minute ) );
      u32Seconds += pTimeDate->s32Second;
   }
   return( u32Seconds );
} // u32GetSeconds

tVoid tclTimeConvert::vGetDateFromElapsedSeconds( tU32             u32ElapsedSeconds,
                                                  OSAL_trTimeDate *pTimeDate,
                                                  tU16             u16TimeDateBase ) const {

   pTimeDate->s32Year = (tS32)u16TimeDateBase;

   tU32 u32Seconds = TIMECONV_U32_SECONDS_PER_YEAR;
   if ( bIsLeapYear( (tS16)pTimeDate->s32Year ) ){
      // add one day for every leap year
      u32Seconds += TIMECONV_U32_SECONDS_PER_DAY;
   }
   while ( u32ElapsedSeconds > u32Seconds ){
      u32ElapsedSeconds -= u32Seconds;
      pTimeDate->s32Year++;

      u32Seconds         = TIMECONV_U32_SECONDS_PER_YEAR;
      if ( bIsLeapYear( (tS16)pTimeDate->s32Year ) ){
         // add one day for every leap year
         u32Seconds += TIMECONV_U32_SECONDS_PER_DAY;
      }
   }

   pTimeDate->s32Month = 1;
   u32Seconds          = ( TIMECONV_U32_SECONDS_PER_DAY * u8DaysPerMonth( (tU8)pTimeDate->s32Month, (tS16)pTimeDate->s32Year ) );
   while ( u32ElapsedSeconds > u32Seconds ){
      u32ElapsedSeconds -= u32Seconds;
      pTimeDate->s32Month++;
      u32Seconds         = ( TIMECONV_U32_SECONDS_PER_DAY * u8DaysPerMonth( (tU8)pTimeDate->s32Month, (tS16)pTimeDate->s32Year ) );
   }
   pTimeDate->s32Day = 1;
   u32Seconds        = TIMECONV_U32_SECONDS_PER_DAY;
   while ( u32ElapsedSeconds > u32Seconds ){
      u32ElapsedSeconds -= u32Seconds;
      pTimeDate->s32Day++;
      u32Seconds         = TIMECONV_U32_SECONDS_PER_DAY;
   }

   pTimeDate->s32Hour   = u32ElapsedSeconds / TIMECONV_U32_SECONDS_PER_HOUR;
   pTimeDate->s32Minute = ( u32ElapsedSeconds - ( TIMECONV_U32_SECONDS_PER_HOUR * pTimeDate->s32Hour ) ) / TIMECONV_U32_SECONDS_PER_MINUTE;
   pTimeDate->s32Second = ( u32ElapsedSeconds - ( TIMECONV_U32_SECONDS_PER_HOUR * pTimeDate->s32Hour ) ) % TIMECONV_U32_SECONDS_PER_MINUTE;

   return;
} // vGetDateFromElapsedSeconds

// EOF

