/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_appsim.h
  * @brief        This is header file contains functions for Appsim.
  * @copyright    (C) 2014 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>

#include "spm_baseClass.h"
#include "spm_ISpmBase.h"

/*!
  *  \class spm_tclAppSim
  *  \brief This class handles constructor / destructor based semaphore.
  */
class spm_tclAppSim : public ISpmBase
{
public:
spm_tclAppSim( const ISpmFactory& factory,
               const std::string& strAppName,
               tU16               u16AppId,
               tU16               u16SrvId );
virtual ~spm_tclAppSim( );

// ISpmBase methods
virtual tVoid vGetReferences( ){}
virtual tVoid vStartCommunication( ){}

virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual const tChar*getName( ) const { return( _strAppName.c_str( ) ); }
virtual const tChar*getInterfaceName( ) const { return( _strAppName.c_str( ) ); }

private:
tU16               _u16AppId;
tU16               _u16SrvId;
std::string        _strAppName;

tBool              _bTerminate;
tBool              _bThreadRunning;

OSAL_tMQueueHandle _hCcaInQueue;
OSAL_tThreadID     _hThreadId;

static tVoid vCcaMsgHandlerThread( tVoid *pvArg );

};

