/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_Registry_pathes.h
  * @brief        This is header file contains all pathes LCM used in OSAL registry
  * @copyright    (C) 2011 - 2017 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

/** generic base path in registry to all entries used in CM software*/
#define SPM_REG_BASE_PATH                                "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/"

/*********************************/
/** Configuration for Processes **/
/*********************************/
/** generic process path in registry */
#define SPM_REG_PROCESS_BASE_PATH                        SPM_REG_BASE_PATH "PROCESS/"

/********************************/
/** Configuration for ProcBase **/
/********************************/
/** registry path to base process  */
#define SPM_REG_PROCESS_BASE_BASE_PATH                   SPM_REG_PROCESS_BASE_PATH "BASE/"
/** registry path to SPM/LCM process */
#define SPM_REG_PROCESS_BASE_SPM_BASE_PATH               SPM_REG_PROCESS_BASE_BASE_PATH "SPM/"
/** registry path to SPM/LCM application in base process */
#define SPM_REG_PROCESS_BASE_SPM_PROCESSES_BASE_PATH     SPM_REG_PROCESS_BASE_SPM_BASE_PATH "PROCESSES/"
/** registry path to additional registries of the SPM/LCM application */
#define SPM_REG_PROCESS_BASE_SPM_REGISTRY_BASE_PATH      SPM_REG_PROCESS_BASE_SPM_BASE_PATH "REGISTRY/"
/** registry path to application states of the SPM/LCM application */
#define SPM_REG_PROCESS_BASE_SPM_STATES_BASE_PATH        SPM_REG_PROCESS_BASE_SPM_BASE_PATH "STATES/"
/** registry path to thread configurations of the SPM/LCM application */
#define SPM_REG_PROCESS_BASE_SPM_THREADINFO_BASE_PATH    SPM_REG_PROCESS_BASE_SPM_BASE_PATH "THREADINFO/"
/** registry path to applications that are not supervised by the SPM/LCM application */
#define SPM_REG_PROCESS_BASE_SPM_NOTSUPERVISED_BASE_PATH SPM_REG_PROCESS_BASE_SPM_BASE_PATH "NOTSUPERVISED/"

/******************************************************/
/** Configuration for generic Process Configurations **/
/******************************************************/
/** registry path to process configurations */
#define SPM_REG_PROCESS_CONFIG_BASE_PATH                 SPM_REG_PROCESS_BASE_PATH "CONFIG/"

/****************************/
/** Variant Configurations **/
/****************************/
/** registry path to variant handling entries of the SPM/LCM process */
#define SPM_REG_PROCESS_VARIANT_BASE_PATH                SPM_REG_PROCESS_BASE_PATH "VARIANT/"

/*************************/
/** Version information **/
/*************************/
/** registry path to version entries */
#define SPM_REG_VERSIONS_BASE_PATH                          SPM_REG_BASE_PATH "VERSIONS/"
/** registry path to board configuration */
#define SPM_REG_VERSIONS_BOARDCFG_BASE_PATH                 SPM_REG_VERSIONS_BASE_PATH "BOARDCFG/"
/** registry path to entries for OSAL configurations */
#define SPM_REG_VERSIONS_OSAL_BASE_PATH                     SPM_REG_VERSIONS_BASE_PATH "OSAL/"
/** registry path to OSAL device configurations */
#define SPM_REG_VERSIONS_OSAL_DEVICES_BASE_PATH             SPM_REG_VERSIONS_OSAL_BASE_PATH "DEVICES/"
/** registry path to wakeup device configuration */
#define SPM_REG_VERSIONS_OSAL_DEVICES_DEV_WUP_BASE_PATH     SPM_REG_VERSIONS_OSAL_DEVICES_BASE_PATH "DEV_WUP/"
/** registry path to wakeup device configuration used when fake device creating Registry*/
#define SPM_REG_VERSIONS_OSAL_DEVICES_DEV_WUP_FAKE_KEY_FILE SPM_REG_VERSIONS_OSAL_DEVICES_BASE_PATH "DEV_WUP"

#pragma once
