/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_Registry.h
  * @brief        This is header file contains functions to handles registry related operations.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#include "spm_IRegistry.h"
// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------

/*!
  *  \class spm_tclRegistry
  *  \brief This class handles registry related operations. It imports registry data from file.
          It gets string and number from registry .
     class spm_tclStartupCommon uses this class to check presence of software block in registry , to remove software block from registry and
        to import registry data from file.


  */
class spm_tclRegistry : public ISpmRegistry
{
private:
tBool bImportFixBaseData( );

tBool bImportDataFromBuffer( const std::string& strFileData );

reg_tclRegKey      oReg;
reg_tclProcess     oProc;
reg_tclApplication oApp;
reg_tclService     oSvc;

public:
spm_tclRegistry( const ISpmFactory& factory );
virtual ~spm_tclRegistry( ){}

tBool bImportData( const std::string& strFileName,
                   tBool              bFileWithPath = FALSE,
                   const std::string& strKeyToCheck = "" );

tBool bImportDataByFile( const std::string& strFileName,
                         tBool              bFileWithPath = FALSE,
                         const std::string& strKeyToCheck = "" );

tBool bIsSoftwareBlockInRegistry( const std::string& strSwBlockName );

tBool bGetAllApplicationsOfSwBlock( tU16 u16SpmId,
                                    const std::string& strSwBlockName,
                                    std::map < tU16, std::vector < tU16 > >& _mapAppIds );

tBool bFindSwBlockNameOfApp( tU32         u32AppId,
                             std::string& strSwBlockName );

tVoid vTraceOutRegistry( const std::string& strName );

tBool bGetStringFromRegistry( const std::string& strPath,
                              const std::string& strKey,
                              std::string      & strResult );

tBool bGetNumberFromRegistry( const std::string& strPath,
                              const std::string& strKey,
                              tU32             & u32Result );

// remove an entry from the registry
tVoid vRemoveEntry( const std::string& strPath,
                    const std::string& strKey ) const;

// remove complete SwBlock from the registry
tBool bRemoveSoftwareBlock( const std::string& szKeyName );

const reg_tclRegKey*getRegkey( ){ return( &oReg ); }
const reg_tclProcess*getRegProcess( ){ return( &oProc ); }
const reg_tclApplication*getRegApplication( ){ return( &oApp ); }
const reg_tclService*getRegService( ){ return( &oSvc ); }

// ISpmBase functions
const tChar*getName( ) const { return( "spm_tclRegistry" ); }
void vGetReferences( ){}
void vStartCommunication( ){}
void vHandleTraceMessage( const tUChar* ){}
};

