/*!
  * \file spm_FsHelper.cpp
  *  \brief
  *        Handles FileSystem access .
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author            | Modification
  * 28.01.16  |                   | initial version
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_trace.h"
#include "spm_FsHelper.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_FsHelper.cpp.trc.h"
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/


// ***************** F U N C T I O N  H E A D E R **************************
//
// DESCRIPTION:
//
// ! \brief
// !    Check if the critical section is locked.
// !
// ! \return
// !   true if the semphore is locked, else false in all other cases
// HISTORY:
// Date            |  Author                       | MODIFICATION
// -------------------------------------------------------------------------
// **************************************************************************
tBool spm_bIsFileInFs( const std::string& strFile ){
   tBool              bRet = FALSE;

   OSAL_tIODescriptor fd   = OSAL_IOOpen( strFile.c_str( ), OSAL_EN_READONLY );

   if ( fd != OSAL_ERROR ){
      bRet = TRUE;
      OSAL_s32IOClose( fd );
   }
   return( bRet );
}

