/*!
  * \file  spm_CcaSupplierHandler_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclCcaSupplierHandler_include_ext: user specific code start
// my class header
#include "spm_CcaSupplierHandler.h"
// my class header
// my class header
// spm_tclCcaSupplierHandler_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_CcaSupplierHandler_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclCcaSupplierHandler_include_spm: user specific code start
// spm_tclCcaSupplierHandler_include_spm: user specific code end


tVoid spm_tclCcaSupplierHandler::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SPMSUPPLIERINFO:
      {

         // SpmSupplierInfo: user specific code start
         vTraceSupplierInfo();
         // SpmSupplierInfo: user specific code end
      }
      break;

      case SPM_SPMSUPPLIERSHOWERRORS:
      {

         // SpmSupplierShowErrors: user specific code start
         vTraceErrors();
         // SpmSupplierShowErrors: user specific code end
      }
      break;

      case SPM_SPMSUPPLIERADDNOTIFICATIONENTRY:
      {
         tU16 param1 = (tU16)((puchData[3]<<8) | puchData[4]);
         tU16 param2 = (tU16)((puchData[5]<<8) | puchData[6]);
         tU16 param3 = (tU16)((puchData[7]<<8) | puchData[8]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSupplierAddNotificationEntry' was called: param1 = 0x%x, param2 = 0x%x, param3 = 0x%x", param1, param2, param3 ) );

         // SpmSupplierAddNotificationEntry: user specific code start
         bAddNotificationEntry( (tU16)param1, // u16SupplierId
                                (tU16)param2, // u16DstAppId
                                (tU16)param3, // u16ServiceId
                                0,            // SourceSubId
                                0);           // TargetSubId
         // SpmSupplierAddNotificationEntry: user specific code end
      }
      break;

      case SPM_SPMSUPPLIERREMOVENOTIFICATIONENTRY:
      {
         tU16 param1 = (tU16)((puchData[3]<<8) | puchData[4]);
         tU16 param2 = (tU16)((puchData[5]<<8) | puchData[6]);
         tU16 param3 = (tU16)((puchData[7]<<8) | puchData[8]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSupplierRemoveNotificationEntry' was called: param1 = 0x%x, param2 = 0x%x, param3 = 0x%x", param1, param2, param3 ) );

         // SpmSupplierRemoveNotificationEntry: user specific code start
         bRemoveNotificationEntry( (tU16)param1, // u16SupplierId
                                   (tU16)param2, // u16DstAppId
                                   (tU16)param3, // u16ServiceId
                                   0,            // SourceSubId
                                   0);           // TargetSubId
         // SpmSupplierRemoveNotificationEntry: user specific code end
      }
      break;

      case SPM_SPMSUPPLIERADDNEWSERVICE:
      {
         tU16 param1 = (tU16)((puchData[3]<<8) | puchData[4]);
         tU16 param2 = (tU16)((puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSupplierAddNewService' was called: param1 = 0x%x, param2 = 0x%x", param1, param2 ) );

         // SpmSupplierAddNewService: user specific code start
         vAddNewService( (tU16)param1,  // u16ServiceId
                         (tU16)param2); // u16SupplierId
         // SpmSupplierAddNewService: user specific code end
      }
      break;

      case SPM_SPMSUPPLIERCHANGESERVICENOTIFICATION:
      {
         tU16 param1 = (tU16)((puchData[3]<<8) | puchData[4]);
         tU16 param2 = (tU16)((puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSupplierChangeServiceNotification' was called: param1 = 0x%x, param2 = 0x%x", param1, param2 ) );

         // SpmSupplierChangeServiceNotification: user specific code start
         amt_tclServiceSupplierRegister oSrvSupplierReg( (tU16)param2,      // u16Source
                                                         CCA_C_U16_APP_SPM, // u16Target
                                                         (tU16)param1);     // u16ServiceID
         bChangeServiceNotification(oSrvSupplierReg);
         // SpmSupplierChangeServiceNotification: user specific code end
      }
      break;

      case SPM_SPMSUPPLIERSTATECHANGED:
      {
         tU16 param1 = (tU16)((puchData[3]<<8) | puchData[4]);
         tU16 param2 = (tU16)((puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSupplierStateChanged' was called: param1 = 0x%x, param2 = 0x%x", param1, param2 ) );

         // SpmSupplierStateChanged: user specific code start
         vSupplierStateChanged( (tU16)param1, // u16SupplierId
                                param2);      // u32AppState
         // SpmSupplierStateChanged: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclCcaSupplierHandlerFunction: user specific code start
     // spm_tclCcaSupplierHandlerFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclCcaSupplierHandlerFile: user specific code start
// spm_tclCcaSupplierHandlerFile: user specific code end

