/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ICcaServiceServer.h
  * @brief        This is header file contains interfaces to evaluate cca service messages.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#define AMT_S_IMPORT_INTERFACE_GENERIC
#include "amt_if.h"

// provide several properties on cfc_spm_fi
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#include "spm_IWorkerClient.h"
#include "spm_ISystemInfoClient.h"

class ISpmClientHandlerBase;

// //////////////////////////////////////////////////////////////////////////////
// Interface to evaluate cca service messages

/*!
  *  \class ISpmCcaServiceServer
  *  \brief This abstract class provides interfaces to evaluate cca service messages.
          This class also supplies pure virtual functions to handle registering and unregistering of service.

  */
class ISpmCcaServiceServer : public ISpmWorkerClient
   , public ISpmSystemInfoClient
{
public:
ISpmCcaServiceServer( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){}
virtual ~ISpmCcaServiceServer( ){}
virtual tBool bHandleServiceRegister( const amt_tclServiceRegister *poSrvReg )          = 0;

virtual tBool bHandleServiceUnregister( const amt_tclServiceUnregister *poSrvReg )      = 0;

virtual tBool bHandleServiceConfirmation( const amt_tclServiceRegisterConf *poSrvConf ) = 0;

virtual tBool bHandleServiceStatus( const amt_tclServiceStatus *poSrvStatus )           = 0;

virtual tVoid vOnServiceDataMessage( amt_tclServiceData *poSrvData )                    = 0;

virtual tBool bRegisterServices( tU32 u32AppId )                                        = 0;

virtual tVoid vAddClientHandler( ISpmClientHandlerBase *pClient )                    = 0;

virtual tVoid vStartCommunication( )                                                    = 0;

virtual tBool bRestartTrigger( ) const                                                  = 0;

virtual tVoid SetRestartTrigger( tBool bTrigger )                                       = 0;

virtual tVoid vUpdateProperty( tU16                  u16Fid,
                               const fi_tclTypeBase *pMsgBase )                         = 0;

virtual tBool bGetSysModeState( )                                                       = 0;

virtual tVoid vSetSysModeState( tBool bMode )                                           = 0;

virtual tBool bSetDlLockStateRequest(std::string strLockArea,
                                     tU16        u16ReqAppId,
                                     tU32        u32LockCommand)                        = 0;
virtual tBool bUpdateLock(std::string strLock, tU32 u32LockCommand, tU16 u16ReqAppId)       = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmCcaServiceServer" ); }
// generic method handling
virtual tVoid vUpdateMethodResult( tU16                  u16Fid,
                                   const fi_tclTypeBase *pMsgBase,
                                   tU8                   u8OpCode = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) = 0;

virtual tVoid vPostInternalMessage( tU16   u16Cmd,
                                    tVoid *pInternalMsg = NULL,
                                    tU32   u32Len = 0 )                                                   = 0;

};

