/*!
  * \file  spm_CcaServiceHandler_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclCcaServiceHandler_include_ext: user specific code start
// my class header
#include "spm_CcaServiceHandler.h"
// my class header
// my class header
// spm_tclCcaServiceHandler_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_CcaServiceHandler_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclCcaServiceHandler_include_spm: user specific code start
// spm_tclCcaServiceHandler_include_spm: user specific code end


tVoid spm_tclCcaServiceHandler::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_GETSHOWCCAPROPERTYSTATE:
      {

         // GetShowCcaPropertyState: user specific code start
         vTraceInfo();
         // GetShowCcaPropertyState: user specific code end
      }
      break;

      case SPM_SPMGETNOTTAB:
      {
         tU16 param1 = (tU16)((puchData[3]<<8) | puchData[4]);

         // SpmGetNotTab: user specific code start
         if (param1 == 0){
            // trace all information about notification tab out
            vTraceAllNotificationTabs();
         } else {
            // trace the registered components of one dedicated property
            vTraceNotificationTab( (tU16)param1);
         }
         // SpmGetNotTab: user specific code end
      }
      break;

      case SPM_SPMTRIGGERHMISTATE:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerHmiState' was called: param1 = 0x%x", param1 ) );

         // SpmTriggerHmiState: user specific code start
         spm_corefi_tclMsgHmiStateStatus hmistatus;

         hmistatus.HmiState.enType = (spm_fi_tcl_SPM_e32_HMI_STATE::tenType)param1;
         vUpdateProperty(SPM_COREFI_C_U16_HMISTATE, &hmistatus);

         // SpmTriggerHmiState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERDIMSTATE:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerDimState' was called: param1 = 0x%x", param1 ) );

         // SpmTriggerDimState: user specific code start
         spm_corefi_tclMsgDimStateStatus dimstatus;

         dimstatus.DimState.enType = (spm_fi_tcl_SPM_e32_DIM_STATE::tenType)param1;
         vUpdateProperty(SPM_COREFI_C_U16_DIMSTATE, &dimstatus);
         // SpmTriggerDimState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERSYSSTATE:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerSysState' was called: param1 = 0x%x", param1 ) );

         // SpmTriggerSysState: user specific code start
         param1 = param1;
         // SpmTriggerSysState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERRVCSTATE:
      {
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerRVCState' was called: param1 = 0x%x", param1 ) );

         // SpmTriggerRVCState: user specific code start
         param1 = param1;
         // SpmTriggerRVCState: user specific code end
      }
      break;

      case SPM_SPMTRIGGERMOSTREMOTERESET:
      {
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerMostRemoteReset' was called" ) );

         // SpmTriggerMostRemoteReset: user specific code start
         // SpmTriggerMostRemoteReset: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclCcaServiceHandlerFunction: user specific code start
     // spm_tclCcaServiceHandlerFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclCcaServiceHandlerFile: user specific code start
// spm_tclCcaServiceHandlerFile: user specific code end

