/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CcaServiceHandlerMsg.h
  * @brief        This is header file contains implemention for specific LCM CCA service messages and report error.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

// Class used to report error

/*!
  *  \class spm_tclServiceErrorStatus
  *  \brief This class implements specific SPM CCA service messages and report error.
          it is used by spm_PropertyHandling to send service error message.
  */
class spm_tclServiceErrorStatus : public amt_tclServiceData
{

public:
spm_tclServiceErrorStatus   ( tU16 nSource,
                              tU16 nTarget,
                              tU16 u16RegID,
                              tU16 u16CmdCtr,
                              tU16 u16ServiceID,
                              tU16 u16FuntionID,
                              tU8  u8ACT = 0,
                              tU16 u16SourceSub = 0,
                              tU16 u16TargetSub = 0 );
};

