/*****************************************************************************
 * @file:        spm_CcaServiceHandlerFiParam.cpp
 * PROJECT:      NextGen
 * SW-COMPONENT: FC SPM
 * ----------------------------------------------------------------------------
 *
 * @brief:  Automated generation of method and property variables from
 *          System Power Management Service, Application Functional Interface
 *          Version : $Revision:   1.15  $
 *          Author  : Klaus-Peter Kollai
 *          Title   : SPM_CORE_FI
 *          Date    : $Date:  08.08.2018  $
 *
 * ----------------------------------------------------------------------------
 * @copyright   (C) 2017-2020 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

// FI-zone starts
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

//-----------------------------------------------------------------------------
// includes FC SPM
//-----------------------------------------------------------------------------

#include "spm_Config.h"
#include "spm_trace.h"
#include "spm_CcaServiceHandler.h"

/*lint -save -e726 */ // PQM_authorized_423


enum
{
   GEN_P_SYSTEMSTATE,
   GEN_P_UPDATELOCKSTATES,
   GEN_P_SUBSTATES,
   GEN_P_PHONEMUTESTATE,
   GEN_P_ONTIPPERSTATE,
   GEN_P_MAPDOWNLOADLOCKSTATE,
   GEN_P_STANDBYTIME,
   GEN_P_PERSITENTSTANDBYTIME,
   GEN_P_IGNITIONOFFTIME,
   GEN_P_DOOROPENTIME,
   GEN_P_CLOCKDISPLAYTIME,
   GEN_P_SYSTEMSTATETIME,
   GEN_P_PROCESSLIST,
   GEN_P_WAKEUPREASON,
   GEN_P_STARTUPREASON,
   GEN_P_CONNECTTOBATTERY,
   GEN_P_CODEREQUESTSTATE,
   GEN_P_CVMEVENT,
   GEN_P_UBATSENSE,
   GEN_P_DEVICEPOWERONTIME,
   GEN_P_LASTSYSTEMRUNTIME,
   GEN_P_CURRENTSYSTEMRUNTIME,
   GEN_P_RESETLIST,
   GEN_P_RESETCOUNTER,
   GEN_P_TRANSPORTMODELIST,
   GEN_P_RESETHISTORY,
   GEN_P_WAKEUPHISTORY,
   GEN_P_STATEHISTORY,
   GEN_P_ERRSTATEHISTORY01,
   GEN_P_ERRSTATEHISTORY02,
   GEN_P_ERRSTATEHISTORY03,
   GEN_P_ERRSTATEHISTORY04,
   GEN_P_ERRSTATEHISTORY05,
   GEN_P_SWITCHONHISTORY,
   GEN_P_DEVICEONCOUNTER,
   GEN_P_VOLTAGEEVENTCOUNTER,
   GEN_P_VOLTAGERANGEHISTOGRAM,
   GEN_P_CPUUSAGESTATISTIC,
   GEN_P_RAMUSAGESTATISTIC,
   GEN_P_STARTUPTIMESTATISTIC,
   GEN_P_SWVERSIONSTATISTIC,
   GEN_P_RUNLEVELSTATE,
   GEN_P_RESTART,
   GEN_P_HMISTATE,
   GEN_P_DIMSTATE,
   GEN_P_DIMMINGSTATE,
   GEN_P_BLUETOOTHSTATE,
   GEN_P_AUDIOSTATE,
   GEN_P_SPISTATE,
   GEN_P_TUNERSTATE,
   GEN_P_ONOFFREASON,
   GEN_P_WAKEUPLIST,
   GEN_P_VEHICLEID,
};

enum
{
   GEN_M_SYSTEMMODE,
   GEN_M_DOWNLOADLOCKSTATE,
   GEN_M_UPDATELOCK,
   GEN_M_ONOFFTRIGGER,
   GEN_M_STARTPROCESS,
   GEN_M_STOPPROCESS,
   GEN_M_RESTARTPROCESS,
   GEN_M_STARTUPSYNCPOINTREACHED,
   GEN_M_CLEARLIST,
   GEN_M_SPECIFICSWVERSIONSTATISTIC,
   GEN_M_RESTARTSYSTEM,
   GEN_M_AUDIOSOURCECHANGE,
   GEN_M_SHUTDOWNANDTERMINATECCAAPPS,
};


spm_AdminProperty arProperties[] =
{
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "SystemState"          }, // SYSTEMSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "UpdateLockStates"     }, // UPDATELOCKSTATES
   { NULL, SPM_PROP_ADMIN_GET_SET_UPREG, "SubStates"            }, // SUBSTATES
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "PhoneMuteState"       }, // PHONEMUTESTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "OnTipperState"        }, // ONTIPPERSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "MapDownloadLockState" }, // MAPDOWNLOADLOCKSTATE
   { NULL, SPM_PROP_ADMIN_GET_SET,       "StandbyTime"          }, // STANDBYTIME
   { NULL, SPM_PROP_ADMIN_GET_SET,       "PersitentStandbyTime" }, // PERSITENTSTANDBYTIME
   { NULL, SPM_PROP_ADMIN_GET_SET,       "IgnitionOffTime"      }, // IGNITIONOFFTIME
   { NULL, SPM_PROP_ADMIN_GET_SET,       "DoorOpenTime"         }, // DOOROPENTIME
   { NULL, SPM_PROP_ADMIN_GET_SET,       "ClockDisplayTime"     }, // CLOCKDISPLAYTIME
   { NULL, SPM_PROP_ADMIN_GET_SET,       "SystemStateTime"      }, // SYSTEMSTATETIME
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "ProcessList"          }, // PROCESSLIST
   { NULL, SPM_PROP_ADMIN_GET,           "WakeupReason"         }, // WAKEUPREASON
   { NULL, SPM_PROP_ADMIN_GET,           "StartupReason"        }, // STARTUPREASON
   { NULL, SPM_PROP_ADMIN_GET,           "ConnectToBattery"     }, // CONNECTTOBATTERY
   { NULL, SPM_PROP_ADMIN_GET_SET_UPREG, "CodeRequestState"     }, // CODEREQUESTSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "CvmEvent"             }, // CVMEVENT
   { NULL, SPM_PROP_ADMIN_GET,           "UBatSense"            }, // UBATSENSE
   { NULL, SPM_PROP_ADMIN_GET_SET,       "DevicePowerOnTime"    }, // DEVICEPOWERONTIME
   { NULL, SPM_PROP_ADMIN_GET,           "LastSystemRuntime"    }, // LASTSYSTEMRUNTIME
   { NULL, SPM_PROP_ADMIN_GET,           "CurrentSystemRuntime" }, // CURRENTSYSTEMRUNTIME
   { NULL, SPM_PROP_ADMIN_GET_SET,       "ResetList"            }, // RESETLIST
   { NULL, SPM_PROP_ADMIN_GET_SET_UPREG, "ResetCounter"         }, // RESETCOUNTER
   { NULL, SPM_PROP_ADMIN_GET_SET,       "TransportModeList"    }, // TRANSPORTMODELIST
   { NULL, SPM_PROP_ADMIN_GET_SET,       "ResetHistory"         }, // RESETHISTORY
   { NULL, SPM_PROP_ADMIN_GET_SET,       "WakeupHistory"        }, // WAKEUPHISTORY
   { NULL, SPM_PROP_ADMIN_GET_SET,       "StateHistory"         }, // STATEHISTORY
   { NULL, SPM_PROP_ADMIN_GET_SET,       "ErrStateHistory01"    }, // ERRSTATEHISTORY01
   { NULL, SPM_PROP_ADMIN_GET_SET,       "ErrStateHistory02"    }, // ERRSTATEHISTORY02
   { NULL, SPM_PROP_ADMIN_GET_SET,       "ErrStateHistory03"    }, // ERRSTATEHISTORY03
   { NULL, SPM_PROP_ADMIN_GET_SET,       "ErrStateHistory04"    }, // ERRSTATEHISTORY04
   { NULL, SPM_PROP_ADMIN_GET_SET,       "ErrStateHistory05"    }, // ERRSTATEHISTORY05
   { NULL, SPM_PROP_ADMIN_GET_SET,       "SwitchOnHistory"      }, // SWITCHONHISTORY
   { NULL, SPM_PROP_ADMIN_GET,           "DeviceOnCounter"      }, // DEVICEONCOUNTER
   { NULL, SPM_PROP_ADMIN_GET,           "VoltageEventCounter"  }, // VOLTAGEEVENTCOUNTER
   { NULL, SPM_PROP_ADMIN_GET,           "VoltageRangeHistogram" }, // VOLTAGERANGEHISTOGRAM
   { NULL, SPM_PROP_ADMIN_GET,           "CpuUsageStatistic"    }, // CPUUSAGESTATISTIC
   { NULL, SPM_PROP_ADMIN_GET,           "RamUsageStatistic"    }, // RAMUSAGESTATISTIC
   { NULL, SPM_PROP_ADMIN_GET,           "StartupTimeStatistic" }, // STARTUPTIMESTATISTIC
   { NULL, SPM_PROP_ADMIN_GET,           "SWVersionStatistic"   }, // SWVERSIONSTATISTIC
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "RunlevelState"        }, // RUNLEVELSTATE
   { NULL, SPM_PROP_ADMIN_GET_SET_UPREG, "Restart"              }, // RESTART
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "HmiState"             }, // HMISTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "DimState"             }, // DIMSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "DimmingState"         }, // DIMMINGSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "BluetoothState"       }, // BLUETOOTHSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "AudioState"           }, // AUDIOSTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "SpiState"             }, // SPISTATE
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "TunerState"           }, // TUNERSTATE
   { NULL, SPM_PROP_ADMIN_GET_SET_UPREG, "OnOffReason"          }, // ONOFFREASON
   { NULL, SPM_PROP_ADMIN_GET_SET,       "WakeupList"           }, // WAKEUPLIST
   { NULL, SPM_PROP_ADMIN_GET_UPREG,     "VehicleID"            }, // VEHICLEID
};

spm_AdminMethod   arMethods[] =
{
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "SystemMode"        }, // SYSTEMMODE
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "DownloadLockState" }, // DOWNLOADLOCKSTATE
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "UpdateLock"        }, // UPDATELOCK
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "OnOffTrigger"      }, // ONOFFTRIGGER
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "StartProcess"      }, // STARTPROCESS
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "StopProcess"       }, // STOPPROCESS
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "RestartProcess"    }, // RESTARTPROCESS
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "StartUpSyncPointReached" }, // STARTUPSYNCPOINTREACHED
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "ClearList"         }, // CLEARLIST
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "SpecificSWVersionStatistic" }, // SPECIFICSWVERSIONSTATISTIC
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "RestartSystem"     }, // RESTARTSYSTEM
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "AudioSourceChange" }, // AUDIOSOURCECHANGE
   { NULL, SPM_METHOD_ADMIN_METHODRESULT, "ShutdownAndTerminateCcaApps" }, // SHUTDOWNANDTERMINATECCAAPPS
};

#define ADD_GEN_PROPERTY(a, b) \
   arProperties[GEN_P_ ## a]._pProperty = &b; \
   _oSpmProperties.vAddProperty(SPM_COREFI_C_U16_ ## a, &arProperties[GEN_P_ ## a])

#define ADD_GEN_METHOD(a, b) \
   arMethods[GEN_M_ ## a]._pMethod      = &b; \
   _oSpmMethods.vAddMethod(SPM_COREFI_C_U16_ ## a, &arMethods[GEN_M_ ## a])


tVoid spm_tclCcaServiceHandler::vInitProperties(){
   ADD_GEN_PROPERTY(SYSTEMSTATE,          _systemState);
   ADD_GEN_PROPERTY(UPDATELOCKSTATES,     _updateLockStates);
   ADD_GEN_PROPERTY(SUBSTATES,            _subStates);
   ADD_GEN_PROPERTY(PHONEMUTESTATE,       _phoneMuteState);
   ADD_GEN_PROPERTY(ONTIPPERSTATE,        _onTipperState);
   ADD_GEN_PROPERTY(MAPDOWNLOADLOCKSTATE, _mapDownloadLockState);
   ADD_GEN_PROPERTY(STANDBYTIME,          _standbyTime);
   ADD_GEN_PROPERTY(PERSITENTSTANDBYTIME, _persitentStandbyTime);
   ADD_GEN_PROPERTY(IGNITIONOFFTIME,      _ignitionOffTime);
   ADD_GEN_PROPERTY(DOOROPENTIME,         _doorOpenTime);
   ADD_GEN_PROPERTY(CLOCKDISPLAYTIME,     _clockDisplayTime);
   ADD_GEN_PROPERTY(SYSTEMSTATETIME,      _systemStateTime);
   ADD_GEN_PROPERTY(PROCESSLIST,          _processList);
   ADD_GEN_PROPERTY(WAKEUPREASON,         _wakeupReason);
   ADD_GEN_PROPERTY(STARTUPREASON,        _startupReason);
   ADD_GEN_PROPERTY(CONNECTTOBATTERY,     _connectToBattery);
   ADD_GEN_PROPERTY(CODEREQUESTSTATE,     _codeRequestState);
   ADD_GEN_PROPERTY(CVMEVENT,             _cvmEvent);
   ADD_GEN_PROPERTY(UBATSENSE,            _uBatSense);
   ADD_GEN_PROPERTY(DEVICEPOWERONTIME,    _devicePowerOnTime);
   ADD_GEN_PROPERTY(LASTSYSTEMRUNTIME,    _lastSystemRuntime);
   ADD_GEN_PROPERTY(CURRENTSYSTEMRUNTIME, _currentSystemRuntime);
   ADD_GEN_PROPERTY(RESETLIST,            _resetList);
   ADD_GEN_PROPERTY(RESETCOUNTER,         _resetCounter);
   ADD_GEN_PROPERTY(TRANSPORTMODELIST,    _transportModeList);
   ADD_GEN_PROPERTY(RESETHISTORY,         _resetHistory);
   ADD_GEN_PROPERTY(WAKEUPHISTORY,        _wakeupHistory);
   ADD_GEN_PROPERTY(STATEHISTORY,         _stateHistory);
   ADD_GEN_PROPERTY(ERRSTATEHISTORY01,    _errStateHistory01);
   ADD_GEN_PROPERTY(ERRSTATEHISTORY02,    _errStateHistory02);
   ADD_GEN_PROPERTY(ERRSTATEHISTORY03,    _errStateHistory03);
   ADD_GEN_PROPERTY(ERRSTATEHISTORY04,    _errStateHistory04);
   ADD_GEN_PROPERTY(ERRSTATEHISTORY05,    _errStateHistory05);
   ADD_GEN_PROPERTY(SWITCHONHISTORY,      _switchOnHistory);
   ADD_GEN_PROPERTY(DEVICEONCOUNTER,      _deviceOnCounter);
   ADD_GEN_PROPERTY(VOLTAGEEVENTCOUNTER,  _voltageEventCounter);
   ADD_GEN_PROPERTY(VOLTAGERANGEHISTOGRAM, _voltageRangeHistogram);
   ADD_GEN_PROPERTY(CPUUSAGESTATISTIC,    _cpuUsageStatistic);
   ADD_GEN_PROPERTY(RAMUSAGESTATISTIC,    _ramUsageStatistic);
   ADD_GEN_PROPERTY(STARTUPTIMESTATISTIC, _startupTimeStatistic);
   ADD_GEN_PROPERTY(SWVERSIONSTATISTIC,   _sWVersionStatistic);
   ADD_GEN_PROPERTY(RUNLEVELSTATE,        _runlevelState);
   ADD_GEN_PROPERTY(RESTART,              _restart);
   ADD_GEN_PROPERTY(HMISTATE,             _hmiState);
   ADD_GEN_PROPERTY(DIMSTATE,             _dimState);
   ADD_GEN_PROPERTY(DIMMINGSTATE,         _dimmingState);
   ADD_GEN_PROPERTY(BLUETOOTHSTATE,       _bluetoothState);
   ADD_GEN_PROPERTY(AUDIOSTATE,           _audioState);
   ADD_GEN_PROPERTY(SPISTATE,             _spiState);
   ADD_GEN_PROPERTY(TUNERSTATE,           _tunerState);
   ADD_GEN_PROPERTY(ONOFFREASON,          _onOffReason);
   ADD_GEN_PROPERTY(WAKEUPLIST,           _wakeupList);
   ADD_GEN_PROPERTY(VEHICLEID,            _vehicleID);

   // set the default values of the properties
   // vInitProperties: user specific code start
   spm_corefi_tclMsgSystemStateStatus systemstate;
   systemstate.SystemState.enType                         = spm_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_BACKGROUND;
   _systemState                                           = systemstate;

   spm_corefi_tclMsgSubStatesStatus   substates;
   substates.SubState                                     = 0;
   substates.HwSubState                                   = 0;
   substates.InternSubState                               = 0;
   _subStates                                             = substates;

   spm_corefi_tclMsgCvmEventStatus             cvm;
   cvm.CvmEvent.enType                                    = spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END;
   _cvmEvent                                              = cvm;

   spm_corefi_tclMsgHmiStateStatus             hmi;
   hmi.HmiState.enType                                    = spm_fi_tcl_SPM_e32_HMI_STATE::FI_EN_SPM_U32_HMISTATE_SHOW_OFF;
   _hmiState                                              = hmi;

   spm_corefi_tclMsgDimStateStatus             dim;
   dim.DimState.enType                                    = (spm_fi_tcl_SPM_e32_DIM_STATE::tenType)0;
   _dimState                                              = dim;

   spm_corefi_tclMsgBluetoothStateStatus       tBtState;
   tBtState.BtState.enType                                = spm_fi_tcl_SPM_e32_BT_STATE::FI_EN_BLUETOOTHSTATE_BT_OFF;
   _bluetoothState                                        = tBtState;

   spm_corefi_tclMsgRestartStatus              restart;
   restart.Restart.enType                                 = spm_fi_tcl_SPM_e32_RESTART_TYPE::FI_EN_SPM_U32_RESTART_ECU;
   _restart                                               = restart;

   spm_corefi_tclMsgWakeupReasonStatus         wakeupReason;
   wakeupReason.WakeupReason.enType                       = spm_fi_tcl_SPM_e32_WAKEUP_REASON::FI_EN_SPM_U32_WAKEUP_INVALID;
   _wakeupReason                                          = wakeupReason;
   // vInitProperties: user specific code end
} // vInitProperties

tVoid spm_tclCcaServiceHandler::vInitMethods(){
   ADD_GEN_METHOD(SYSTEMMODE,        _systemMode);
   ADD_GEN_METHOD(DOWNLOADLOCKSTATE, _downloadLockState);
   ADD_GEN_METHOD(UPDATELOCK,        _updateLock);
   ADD_GEN_METHOD(ONOFFTRIGGER,      _onOffTrigger);
   ADD_GEN_METHOD(STARTPROCESS,      _startProcess);
   ADD_GEN_METHOD(STOPPROCESS,       _stopProcess);
   ADD_GEN_METHOD(RESTARTPROCESS,    _restartProcess);
   ADD_GEN_METHOD(STARTUPSYNCPOINTREACHED, _startUpSyncPointReached);
   ADD_GEN_METHOD(CLEARLIST,         _clearList);
   ADD_GEN_METHOD(SPECIFICSWVERSIONSTATISTIC, _specificSWVersionStatistic);
   ADD_GEN_METHOD(RESTARTSYSTEM,     _restartSystem);
   ADD_GEN_METHOD(AUDIOSOURCECHANGE, _audioSourceChange);
   ADD_GEN_METHOD(SHUTDOWNANDTERMINATECCAAPPS, _shutdownAndTerminateCcaApps);
}
/*lint -restore -e726 */

