/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CcaServiceHandler.h
  * @brief        This is header file contains functions for CcaServiceHandler.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// FI-zone starts
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_STDVISITORS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#include "spm_fi_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#include <list>
#include <algorithm>
#define SYSTEM_S_IMPORT_VECTOR


#include "spm_ICcaServiceServer.h"
#include "spm_CcaServiceHandlerAccess.h"
#include "spm_CcaServiceTypes.h"
#include "spm_DownloadLockListManager.h"

class spm_tclCcaServiceAdapter;

class spm_tclServiceWakeUpListStatus;
class spm_tclServiceTransPortModeListStatus;
class spm_tclServiceResetListStatus;

class ISpmClientHandlerBase;

class ISpmWorkerServer;
class ISpmCcaServer;
class ISpmLocalAppManager;
class ISpmSystemPowerManager;
class ISpmApplicationDatabase;
class ISpmSyncHandler;
class ISpmOsLinux;


typedef std::vector < ISpmClientHandlerBase* > TVectorClientHandlerBase;

// !< definition of max entries in the notification table used by the SPM service handler
#define SPM_FUNCARRAY_SIZE                      30
#define SPM_NOTARRAY_SIZE                       80


/*!
  *  \class spm_tclCcaServiceHandler
  *  \brief  This class implements the SPM service .
           ServiceHandler is the component within CCA Framework of SPM that implements the CCA service offered by FC_SPM.
           It creates all the properties and methods, which are then exposed to the other components external to FC_SPM for registration

        It uses these classes spm_tclCcaMsgHandler, spm_tclLocalApplicationManagerConfig, spm_tclSystemPowerManagerConfig, spm_tclApplicationDatabase
        to handle spm services.

        The spm_tclFactory object creates an instance of this class.
          It is used by these classes spm_tclApplicationConfiguration, spm_tclGlobalApplicationManager, spm_tclLocalApplicationManagerConfig, spm_tclCriticalVoltageManager,
        spm_tclCriticalVoltageManagerIntern, spm_tclSystemPowerManager, spm_tclSubStateHandler, spm_tclApplicationConfigurationConfig, spm_tclLamAppManagerConfig
        spm_tclAnimationServiceHandler, spm_tclDownloadServiceHandler, spm_tclHeatControlServiceHandler for generic property and method handling.
  */

class spm_tclCcaServiceHandler : public ISpmCcaServiceServer
{
protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage(const tUChar *puchData);

virtual const tChar*getName() const { return( "spm_tclCcaServiceHandler" ); }
virtual tVoid vStartCommunication();
virtual tVoid vStartLateCommunication();

virtual tVoid vGetReferences();

typedef struct _TCcaSrvClient
{
   tU32 u32AppId;
   tU16 u16RegId;
   tU16 u16SubId;
}_TCcaSrvClient;
typedef std::list < _TCcaSrvClient > _TCcaSrvClientList;

_TCcaSrvClientList          _tClientList;

typedef struct _TDlLock {
   tU16 u16AppIdOwner;
   tU16 u16AppIdRequester;
}TDlLock;
std::map <std::string, TDlLock> _tDlLockList;

tU16                        _u16NextRegisterId;    // for every client we need a unique register id
tBool                       _bRestartTrigger;
tBool                       _bSysModeChangeActive;

ISpmCcaServer              *_poclCcaMsgHandler;
ISpmLocalAppManager        *_poclLocalAppManager;
ISpmSystemPowerManager     *_poclSystemPowerManager;
ISpmApplicationDatabase    *_poclDb;
ISpmWorkerServer           *_poclWorkerServer;
ISpmSyncHandler            *_poclSyncHandler;
ISpmDownloadLockListManager*_poclLockListManager;

spm_PropertyHandling        _oSpmProperties;
spm_MethodHandling          _oSpmMethods;

TVectorClientHandlerBase arClients;

tVoid vInitProperties();

tVoid vInitMethods();

virtual tVoid vUpdateLockListProperty();

public:
virtual tVoid vAddClientHandler(ISpmClientHandlerBase *pClient);

virtual tVoid vRemoveClientHandler(ISpmClientHandlerBase *pClient);

spm_tclCcaServiceHandler(const ISpmFactory& factory);
virtual ~spm_tclCcaServiceHandler();

virtual tBool bRestartTrigger() const {
   return( _bRestartTrigger );
}

virtual tVoid SetRestartTrigger(tBool bTrigger){
   _bRestartTrigger = bTrigger;
}

// implementation of interface ISpmCcaServiceServer
virtual tBool bHandleServiceRegister(const amt_tclServiceRegister *poSrvReg);

virtual tBool bHandleServiceUnregister(const amt_tclServiceUnregister *poSrvReg);

virtual tBool bHandleServiceConfirmation(const amt_tclServiceRegisterConf *poSrvConf);

virtual tBool bHandleServiceStatus(const amt_tclServiceStatus *poSrvStatus);

virtual tVoid vOnServiceDataMessage(amt_tclServiceData *poSrvData);

tVoid vHandleSPMService(amt_tclServiceData *poSrvData);

tVoid vTraceInfoConfigPart();

// Implementation of interface ISpmWorkerClient
virtual tBool bHandleSynchrounousCall(tU32   /*u32Message*/,
                                      tVoid */*args*/){ return( FALSE ); }  //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vHandleMessage(tU32 u32Message,
                             tU32 u32Parm = 0);

virtual tVoid vHandleIgnitionCycleEvent(tU32 /*u32IgnitionCycleEvent*/){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vHandleSysPwrModeEvent(tU32/*u32SysPwrModeEvent*/){}       //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vHandleTriggerMostRemoteReset(){}                       //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vPostInternalMessage(tU16   u16Cmd,
                                   tVoid *pInternalMsg = NULL,
                                   tU32   u32Len = 0);

public:
virtual tBool bRegisterServices(tU32 u32AppId);

tVoid vTraceNotificationTab(tU16 u16FID);

tVoid vTraceAllNotificationTabs();

virtual tVoid vTraceInfo();

tVoid vServiceHandlerRequest(const ahl_tclBaseWork *poSH,
                             tU32                   u32RequestCode);

tBool bIsAppNotifiedToFid(tU32 u32AppId,
                          tU16 u16Fid);

virtual tBool bGetSysModeState(){ return( _bSysModeChangeActive ); }
virtual tVoid vSetSysModeState(tBool bMode){ _bSysModeChangeActive = bMode; }

virtual tBool bSetDlLockStateRequest(std::string strLockArea, tU16 u16ReqAppId, tU32 u32LockCommand);

virtual tBool bUpdateLock(std::string strLock, tU32 u32LockCommand, tU16 u16ReqAppId);

// generic property handling
virtual tVoid vUpdateProperty(tU16                  u16Fid,
                              const fi_tclTypeBase *pMsgBase);

virtual const fi_tclTypeBase*poGetProperty(tU16 u16Fid) const;

// generic method handling
virtual tVoid vUpdateMethodResult(tU16                  u16Fid,
                                  const fi_tclTypeBase *pMsgBase,
                                  tU8                   u8OpCode = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

private:
// include generated parts of the configured CcaServiceHandler
#include "spm_CcaServiceHandlerFiParam.h"
};

