/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_factory_creator.h
  * @brief        This is header file contains functions for creating objects of LCM sub-modules.
  * @copyright    (C) 2015 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

private:
// *************************
// applicationManager
// *************************
ISpmApplicationConfiguration*CreateApplicationConfiguration( );

ISpmApplicationErrorHandler*CreateApplicationErrorHandler( );

ISpmApplicationRequestSupervisor*CreateApplicationRequestSupervisor( );

ISpmGlobalApplicationManager*CreateGlobalApplicationManager( );

ISpmLocalAppManager*CreateLocalApplicationManager( );

ISpmLamAppManager*CreateLamAppManager( );

// *************************
// clienthandler
// *************************
#ifdef VARIANT_S_FTR_ENABLE_INC_SUPPLYMANAGEMENT
   ISpmSupplyMgntIncClientHandler*CreateSupplyMgmtServiceHandler( );

#endif
#ifdef VARIANT_S_FTR_ENABLE_INC_THERMALMANAGEMENT
   ISpmThermalMgntIncClientHandler*CreateThermalMgmtServiceHandler( );

#endif
#ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
   ISpmSystemStateMachineIncClientHandler*CreateSystemStateMachineServiceHandler( );

#endif
   ISpmClientHandlerBase*CreateSpmLateServiceHandler( );

// *************************
// cvm
// *************************
ISpmCvmClient*CreateCriticalVoltageManagerIntern( );

// *************************
// database
// *************************
ISpmProcessDatabase*CreateProcessDatabase( );

ISpmApplicationDatabase*CreateApplicationDatabase( );

ISpmSyncHandler*CreateSyncHandler( );

// *************************
// engineering
// *************************
ISpmStatistics*CreateSubStateStatistics( );

ISpmStatistics*CreatePowerOnCount( );

ISpmStatistics*CreateTransportmodeStatistics( );

ISpmStatistics*CreateSystemStateStatistics( );

ISpmStatistics*CreateWakeupStatistics( );

ISpmStatistics*CreateSwitchOnStatistics( );

ISpmStatistics*CreateResetStatistics( );

ISpmPowerSupplyStatistics*CreatePowerSupplyStatistics( );

ISpmSystemLoadStatistics*CreateCpuUsageStatistics( );

ISpmSystemLoadStatistics*CreateRamUsageStatistics( );

ISpmSystemLoadStatistics*CreateStartupTimeStatistics( );

ISpmStatistics*CreateSWVersionSubStateStatistics( );

ISpmStatistics*CreateSWVersionPowerOnCount( );

ISpmStatistics*CreateSWVersionSystemStateStatistics( );

ISpmStatistics*CreateSWVersionWakeupStatistics( );

ISpmStatistics*CreateSWVersionSwitchOnStatistics( );

ISpmStatistics*CreateSWVersionResetStatistics( );

ISpmSystemLoadStatistics*CreateSWVersionCpuUsageStatistics( );

ISpmSystemLoadStatistics*CreateSWVersionRamUsageStatistics( );

ISpmSystemLoadStatistics*CreateSWVersionStartupTimeStatistics( );

ISpmSoftwareVersionStatistics*CreateSWVersionStatistics( );
// *************************
// framework
// *************************
ISpmCcaServer*CreateCcaMsgHandler( );

ISpmDownloadLockListManager*CreateDownloadLockListManager( );

ISpmCcaServiceServer*CreateCcaServiceHandler( );

ISpmCcaSupplierServer*CreateCcaSupplierHandler( );

// *************************
// helper
// *************************
ISpmRegistry*CreateRegistry( );

// *************************
// platform
// *************************
ISpmOsalProxy*CreateOsalProxy( );

ISpmOsLinux*CreateLinuxProxy( );

ISpmWupOnOffEvents*CreateOsalWupOnOffEvents( );

ISpmWupSupervisionErrorWarning*CreateOsalWupSupervisionErrorWarning( );


ISpmOsalCvm*CreateOsalCvm( );

// *************************
// spm
// *************************
ISpmSystemPowerManager*CreateSystemPowerManager( );

ISpmWakeupHandler*CreateWakeupHandler( );

ISpmTimerHandler*CreateTimerHandler( );

// *************************
// startup
// *************************
ISpmStartupCommon*CreateStartupCommon( );

ISpmStartupInvestigationServer*CreateStartupInvestigation( );

   #ifdef VARIANT_S_FTR_ENABLE_VARIANT_HANDLING
   ISpmStartupSystemVariant*CreateStartupSystemVariant( );

#endif
#ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
   ISpmWorkerClient*CreateProcessShutdown( );

#endif
ISpmStartupSystem*CreateStartupLocal( );

// *************************
// statehandling
// *************************
ISpmSubStateClient*CreateSubStateHandler( );

#ifndef VARIANT_S_FTR_ENABLE_VARIANT_MULTIPLE_FSM
   ISpmSystemStateManager*CreateSystemStateManager( );

#endif
// *************************
// supervision
// *************************
ISpmSupervisionClient*CreateIgnitionOffSupervisor( );

ISpmSupervisionClient*CreateSysStateSupervisor( );

ISpmSupervisionClient*CreateCpuLoadSupervisor( );

ISpmSupervisionClient*CreateRamLoadSupervisor( );

ISpmProcessSupervision*CreateProcessSupervision( );

ISpmSupervisionEnableSupervisor*CreateSupervisionEnableSupervisor( );

ISpmSupervisionManager*CreateSupervisionManager( );

ISpmStartupSupervisor*CreateStartupSupervisor( );

// *************************
// trace
// *************************
ISpmTrace*CreateTrace( );

// *************************
// versions
// *************************
ISpmVersionInfo*CreateVersionInfo( );

// *************************
// worker
// *************************
ISpmWorkerServer*CreateWorkerServer( );

// *****************************
// vdDiagLog cca service handler
// *****************************
#ifdef VARIANT_S_FTR_ENABLE_USE_SPM_DIAGLOG
ISpmClientHandlerBase*CreateVdDiagLogCcaServiceHandler();
#endif
