/*!
  * \file spm_factory_creator.cpp
  *  \brief
  *   Creates the classes of LCM. This is put into an separate file to overwrite this functionality in
  *   UnitTests. Here the real component is created, but UnitTests the pointer to the mock is returned
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * 1.0 | 21.07.15  | CM/ESO3 Rossner | first version
  ******
  */

#include "spm_Config.h"

#include "spm_factory.h"
#include "spm_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_VARIANT_HANDLING
#include "spm_StartupSystemVariant.h"
#endif
#include "spm_StartupCommon.h"
#include "spm_StartupLocal.h"
#include "spm_StartupInvestigation.h"
#include "spm_SystemStateManagerConfig.h"

#define SPM_FACTORY_DELETE( poClass )   if ( poClass ) delete poClass

// *************************
// applicationManager
// *************************
#include "spm_ApplicationConfigurationConfig.h"
#include "spm_ApplicationErrorHandler.h"
#include "spm_ApplicationRequestSupervisor.h"
#include "spm_GlobalApplicationManager.h"
#include "spm_LocalApplicationManagerConfig.h"
#include "spm_LamAppManagerConfig.h"

ISpmApplicationConfiguration*spm_tclFactory::CreateApplicationConfiguration( ){
   return ( new spm_tclApplicationConfigurationConfig( * this ) );
}

ISpmApplicationErrorHandler*spm_tclFactory::CreateApplicationErrorHandler( ){
   return ( new spm_tclApplicationErrorHandler( * this ) );
}

ISpmApplicationRequestSupervisor*spm_tclFactory::CreateApplicationRequestSupervisor( ){
   return ( new spm_tclApplicationRequestSupervisor( * this ) );
}

ISpmGlobalApplicationManager*spm_tclFactory::CreateGlobalApplicationManager( ){
   return ( new spm_tclGlobalApplicationManager( * this ) );
}

ISpmLocalAppManager*spm_tclFactory::CreateLocalApplicationManager( ){
   return ( new spm_tclLocalApplicationManagerConfig( * this, CCA_C_U16_APP_SPM, SPM_GAM_CCA_LOCAL_LAM ) );
}

ISpmLamAppManager*spm_tclFactory::CreateLamAppManager( ){
   return ( new spm_tclLamAppManagerConfig( * this ) );
}

// *************************
// clienthandler
// *************************
#ifdef VARIANT_S_FTR_ENABLE_INC_THERMALMANAGEMENT
#include "spm_ThermalManagementServiceHandlerConfig.h"
   ISpmThermalMgntIncClientHandler*spm_tclFactory::CreateThermalMgmtServiceHandler( ){
      return ( new spm_tclThermalManagementServiceHandlerConfig( * this ) );
   }

#endif
#ifdef VARIANT_S_FTR_ENABLE_INC_SUPPLYMANAGEMENT
#include "spm_SupplyManagementServiceHandlerConfig.h"
   ISpmSupplyMgntIncClientHandler*spm_tclFactory::CreateSupplyMgmtServiceHandler( ){
      return ( new spm_tclSupplyManagementServiceHandlerConfig( * this ) );
   }

#endif
#ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
#include "spm_SystemStateMachineServiceHandlerConfig.h"
   ISpmSystemStateMachineIncClientHandler*spm_tclFactory::CreateSystemStateMachineServiceHandler( ){
      return ( new spm_tclSystemStateMachineServiceHandlerConfig( * this ) );
   }

#endif
#include "spm_LateServiceHandler.h"
   ISpmClientHandlerBase*spm_tclFactory::CreateSpmLateServiceHandler( ){
      return ( new spm_tclSpmLateServiceHandler( * this ) );
   }

// *************************
// cvm
// *************************
#include "spm_CriticalVoltageManagerIntern.h"

ISpmCvmClient*spm_tclFactory::CreateCriticalVoltageManagerIntern( ){
   return ( new spm_tclCriticalVoltageManagerIntern( * this ) );
}

// *************************
// database
// *************************
#include "spm_ApplicationDatabase.h"
#include "spm_ProcessDatabase.h"

ISpmApplicationDatabase*spm_tclFactory::CreateApplicationDatabase( ){
   return ( new spm_tclApplicationDatabase( CCA_C_U16_APP_SPM, * this ) );
}

ISpmProcessDatabase*spm_tclFactory::CreateProcessDatabase( ){
   return ( new spm_tclProcessDatabase( * this ) );
}

#include "spm_SyncHandler.h"
ISpmSyncHandler*spm_tclFactory::CreateSyncHandler( ){
   return ( new spm_tclSyncHandler( * this ) );
}

// *************************
// engineering
// *************************
#include "spm_ResetStatistics.h"
#include "spm_SubStatesStatistics.h"
#include "spm_SwitchOnStatistics.h"
#include "spm_SystemStateStatistics.h"
#include "spm_WakeupStatistics.h"
#include "spm_TransportmodeStatistics.h"
#include "spm_PowerOnCount.h"
#include "spm_PowerSupplyStatistics.h"
#include "spm_SystemLoadStatistics.h"
#include "spm_SoftwareVersionStatistics.h"

ISpmStatistics*spm_tclFactory::CreateSubStateStatistics( ){
   return ( new spm_tclSubStateStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreatePowerOnCount( ){
   return ( new spm_tclPowerOnCount( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateTransportmodeStatistics( ){
   return ( new spm_tclTransportmodeStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateSystemStateStatistics( ){
   return ( new spm_tclSystemStateStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateWakeupStatistics( ){
   return ( new spm_tclWakeupStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateSwitchOnStatistics( ){
   return ( new spm_tclSwitchOnStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateResetStatistics( ){
   return ( new spm_tclResetStatistics( * this ) );
}

ISpmPowerSupplyStatistics*spm_tclFactory::CreatePowerSupplyStatistics( ){
   return ( new spm_tclPowerSupplyStatistics( * this ) );
}

ISpmSystemLoadStatistics*spm_tclFactory::CreateCpuUsageStatistics( ){
   return ( new spm_tclCpuUsageStatistics( * this ) );
}

ISpmSystemLoadStatistics*spm_tclFactory::CreateRamUsageStatistics( ){
   return ( new spm_tclRamUsageStatistics( * this ) );
}

ISpmSystemLoadStatistics*spm_tclFactory::CreateStartupTimeStatistics( ){
   return ( new spm_tclStartupTimeStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateSWVersionSubStateStatistics( ){
   return ( new spm_tclSWVersionSubStateStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateSWVersionPowerOnCount( ){
   return ( new spm_tclSWVersionPowerOnCount( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateSWVersionSystemStateStatistics( ){
   return ( new spm_tclSWVersionSystemStateStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateSWVersionWakeupStatistics( ){
   return ( new spm_tclSWVersionWakeupStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateSWVersionSwitchOnStatistics( ){
   return ( new spm_tclSWVersionSwitchOnStatistics( * this ) );
}

ISpmStatistics*spm_tclFactory::CreateSWVersionResetStatistics( ){
   return ( new spm_tclSWVersionResetStatistics( * this ) );
}

ISpmSystemLoadStatistics*spm_tclFactory::CreateSWVersionCpuUsageStatistics( ){
   return ( new spm_tclSWVersionCpuUsageStatistics( * this ) );
}

ISpmSystemLoadStatistics*spm_tclFactory::CreateSWVersionRamUsageStatistics( ){
   return ( new spm_tclSWVersionRamUsageStatistics( * this ) );
}

ISpmSystemLoadStatistics*spm_tclFactory::CreateSWVersionStartupTimeStatistics( ){
   return ( new spm_tclSWVersionStartupTimeStatistics( * this ) );
}

ISpmSoftwareVersionStatistics*spm_tclFactory::CreateSWVersionStatistics( ){
   return ( new spm_tclSoftwareVersionStatistics( * this ) );
}
// *************************
// framework
// *************************
#include "spm_CcaMsgHandler.h"
#include "spm_DownloadLockListManager.h"
#include "spm_CcaServiceHandlerConfig.h"
#include "spm_CcaSupplierHandlerConfig.h"

ISpmCcaServer*spm_tclFactory::CreateCcaMsgHandler( ){
   return ( new spm_tclCcaMsgHandler( * this, CCA_C_U16_APP_SPM ) );
}

ISpmDownloadLockListManager*spm_tclFactory::CreateDownloadLockListManager( ){
   return ( new spm_tclDownloadLockListManager( * this ) );
}

ISpmCcaServiceServer*spm_tclFactory::CreateCcaServiceHandler( ){
   return ( new spm_tclCcaServiceHandlerConfig( * this ) );
}

ISpmCcaSupplierServer*spm_tclFactory::CreateCcaSupplierHandler( ){
   return ( new spm_tclCcaSupplierHandler( * this ) );
}

// *************************
// helper
// *************************
#include "spm_Registry.h"
ISpmRegistry*spm_tclFactory::CreateRegistry( ){
   return ( new spm_tclRegistry( * this ) );
}

// *************************
// platform
// *************************
#include "spm_OsalWupOnOffEvents.h"
#include "spm_OsalWupSupervisionErrorWarning.h"
#include "spm_OsalProxyConfig.h"
#include "spm_OsalCvm.h"
#include "spm_OsLinux.h"

ISpmOsalProxy*spm_tclFactory::CreateOsalProxy( ){
   return ( new spm_tclOsalProxyConfig( * this, CCA_C_U16_APP_SPM ) );
}

ISpmOsLinux*spm_tclFactory::CreateLinuxProxy( ){
   return ( new spm_tclOsLinux( * this ) );
}

ISpmWupOnOffEvents*spm_tclFactory::CreateOsalWupOnOffEvents( ){
   return ( new spm_tclOsalWupOnOffEvents( * this ) );
}

ISpmWupSupervisionErrorWarning*spm_tclFactory::CreateOsalWupSupervisionErrorWarning( ){
   return ( new spm_tclOsalWupSupervisionErrorWarning( * this ) );
}

ISpmOsalCvm*spm_tclFactory::CreateOsalCvm( ){
   return ( new spm_tclOsalCvm( * this ) );
}

// *************************
// spm
// *************************
#include "spm_WakeupHandler.h"
#include "spm_TimerHandler.h"
#include "spm_SystemPowerManagerConfig.h"

ISpmWakeupHandler*spm_tclFactory::CreateWakeupHandler( ){
   return ( new spm_tclWakeupHandler( * this ) );
}

ISpmTimerHandler*spm_tclFactory::CreateTimerHandler( ){
   return ( new spm_tclTimerHandler( * this ) );
}

ISpmSystemPowerManager*spm_tclFactory::CreateSystemPowerManager( ){
   return ( new spm_tclSystemPowerManagerConfig( * this ) );
}

// *************************
// startup
// *************************
#include "spm_StartupCommon.h"
#include "spm_StartupInvestigation.h"

ISpmStartupCommon*spm_tclFactory::CreateStartupCommon( ){
   return ( new spm_tclStartupCommon( CCA_C_U16_APP_SPM, * this ) );
}

ISpmStartupInvestigationServer*spm_tclFactory::CreateStartupInvestigation( ){
   return ( new spm_tclStartupInvestigation( SPM_SEMAPHORE_STARTUP_INVEST, * this ) );
}

#ifdef VARIANT_S_FTR_ENABLE_VARIANT_HANDLING
#include "spm_StartupSystemVariant.h"

   ISpmStartupSystemVariant*spm_tclFactory::CreateStartupSystemVariant( ){
      return ( new spm_tclStartupSystemVariant( * this ) );
   }

#endif

#ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
#include "spm_ProcessShutdown.h"
   ISpmWorkerClient*spm_tclFactory::CreateProcessShutdown( ){
      return ( new spm_ProcessShutdown( * this ) );
   }

#endif
#include "spm_StartupLocal.h"
ISpmStartupSystem*spm_tclFactory::CreateStartupLocal( ){
   return ( new spm_tclStartupLocal( * this, SPM_STARTUP_CONFIGURATION_CONFIG_PATH1, "1" ) );
}

// *************************
// statehandling
// *************************
#include "spm_SubStateHandlerConfig.h"

ISpmSubStateClient*spm_tclFactory::CreateSubStateHandler( ){
   return ( new spm_tclSubStateHandlerConfig( * this, CCA_C_U16_APP_SPM ) );
}

#ifndef VARIANT_S_FTR_ENABLE_VARIANT_MULTIPLE_FSM
#include "spm_SystemStateManagerConfig.h"
   ISpmSystemStateManager*spm_tclFactory::CreateSystemStateManager( ){
      return ( new spm_tclSystemStateManagerConfig( * this ) );
   }

#endif
// *************************
// supervision
// *************************
#include "spm_CpuLoadSupervisor.h"
#include "spm_RamLoadSupervisor.h"
#include "spm_IgnitionOffSupervisor.h"
#include "spm_SuperVisionManager.h"
#include "spm_SysStateSupervisor.h"
#include "spm_ProcessSupervision.h"
#include "spm_SupervisionEnableSupervisor.h"
#include "spm_StartupSupervisor.h"

ISpmSupervisionManager*spm_tclFactory::CreateSupervisionManager( ){
   return ( new spm_tclSupervisionManager( * this, SPM_HW_WATCHDOG_DEFAULT_INTERVAL ) );
}

ISpmSupervisionClient*spm_tclFactory::CreateSysStateSupervisor( ){
   return ( new spm_tclSysStateSupervisor( * this ) );
}

ISpmStartupSupervisor*spm_tclFactory::CreateStartupSupervisor( ){
   return ( new spm_tclStartupSupervisor( * this ) );
}

ISpmSupervisionClient*spm_tclFactory::CreateIgnitionOffSupervisor( ){
   return ( new spm_tclIgnitionOffSupervisor( * this ) );
}

ISpmSupervisionClient*spm_tclFactory::CreateCpuLoadSupervisor( ){
   return ( new spm_tclCpuLoadSupervisor( * this ) );
}

ISpmSupervisionClient*spm_tclFactory::CreateRamLoadSupervisor( ){
   return ( new spm_tclRamLoadSupervisor( * this ) );
}

ISpmProcessSupervision*spm_tclFactory::CreateProcessSupervision( ){
   return ( new spm_tclProcessSupervision( * this ) );
}

ISpmSupervisionEnableSupervisor*spm_tclFactory::CreateSupervisionEnableSupervisor( ){
   return ( new spm_tclSupervisionEnableSupervisor( * this ) );
}

// *************************
// trace
// *************************

ISpmTrace*spm_tclFactory::CreateTrace( ){
   return ( new spm_tclTrace( * this, TRUE ) );
}

// *************************
// versions
// *************************
#include "spm_VersionInfoConfig.h"

ISpmVersionInfo*spm_tclFactory::CreateVersionInfo( ){
   return ( new spm_tclVersionInfoConfig( * this ) );
}

// *************************
// worker
// *************************
#include "spm_WorkerServerConfig.h"

ISpmWorkerServer*spm_tclFactory::CreateWorkerServer( ){
   return ( new spm_tclWorkerServerConfig( * this ) );
}

// ******************************
// vdDiagLog cca service handler
// ******************************
#ifdef VARIANT_S_FTR_ENABLE_USE_SPM_DIAGLOG
#include "spm_VdDiagLogCcaServiceHandler.h"
ISpmClientHandlerBase*spm_tclFactory::CreateVdDiagLogCcaServiceHandler(){
    return ( new spm_tclVdDiagLogServiceHandler(* this) );
}
#endif

spm_tclFactory::~spm_tclFactory( ){
/*!
  * \fn
  *  \brief
  *    Destructor
  *
  *  \param
  *  \note
  *  \version
  ******
  */
   if ( _poclTrace ){
      _poclTrace->vRemoveTraceClient( _poSPM );
   }
      SPM_FACTORY_DELETE( _poSPM );
      SPM_FACTORY_DELETE( _poclStartupCommon );
      SPM_FACTORY_DELETE( _poclLocalAppManager );
      SPM_FACTORY_DELETE( _poclGlobalApplicationManager );
      SPM_FACTORY_DELETE( _poWorker );
      SPM_FACTORY_DELETE( _poclDb );
      SPM_FACTORY_DELETE( _poclVersionInfo );
      SPM_FACTORY_DELETE( _poclCcaMsgHandler );
      SPM_FACTORY_DELETE( _poSubStateHdl );
      SPM_FACTORY_DELETE( _poclSupervisionManager );
      SPM_FACTORY_DELETE( _poclSysStateSupervisor );
      SPM_FACTORY_DELETE( _poclStartupSupervisor );
      SPM_FACTORY_DELETE( _poSystemStateManager );
      SPM_FACTORY_DELETE( _poclCpuLoadSupervisor );
      SPM_FACTORY_DELETE( _poclRamLoadSupervisor );
      SPM_FACTORY_DELETE( _poServiceHdl );
      SPM_FACTORY_DELETE( _poclAppCfg );
      SPM_FACTORY_DELETE( _poclCcaSupplierHandler );
      SPM_FACTORY_DELETE( _poclCriticalVoltageManagerIntern );
      SPM_FACTORY_DELETE( _poLamAppCfg );
      SPM_FACTORY_DELETE( _poclStartupInvest );
      SPM_FACTORY_DELETE( _poclApplicationRequestSupervisor );
      SPM_FACTORY_DELETE( _poOsLinuxProxy );
      SPM_FACTORY_DELETE( _poclTrace );
      SPM_FACTORY_DELETE( _poclOsalProxy );
      SPM_FACTORY_DELETE( _poclOsalWupOnOffEvents );
      SPM_FACTORY_DELETE( _poclOsalWupSupervisionErrorWarning);
      SPM_FACTORY_DELETE( _poclOsalCvm );
      SPM_FACTORY_DELETE( _poclWakeupStatistic );
      SPM_FACTORY_DELETE( _poResetStatistic );
      SPM_FACTORY_DELETE( _poSubStateStatistic );
      SPM_FACTORY_DELETE( _poPowerOnStatistic );
      SPM_FACTORY_DELETE( _poTransportModeStatistic );
      SPM_FACTORY_DELETE( _poSystemStateStatistic );
      SPM_FACTORY_DELETE( _poPowerSupplyStatistic );
      SPM_FACTORY_DELETE( _poCpuUsageStatistic );
      SPM_FACTORY_DELETE( _poRamUsageStatistic );
      SPM_FACTORY_DELETE( _poStartupTimeStatistic );
      SPM_FACTORY_DELETE( _poSWVersionWakeupStatistic );
      SPM_FACTORY_DELETE( _poSWVersionSwitchOnStatistic );
      SPM_FACTORY_DELETE( _poSWVersionResetStatistic );
      SPM_FACTORY_DELETE( _poSWVersionSubStateStatistic );
      SPM_FACTORY_DELETE( _poSWVersionPowerOnStatistic );
      SPM_FACTORY_DELETE( _poSWVersionSystemStateStatistic );
      SPM_FACTORY_DELETE( _poSWVersionCpuUsageStatistic );
      SPM_FACTORY_DELETE( _poSWVersionRamUsageStatistic );
      SPM_FACTORY_DELETE( _poSWVersionStartupTimeStatistic );
      SPM_FACTORY_DELETE( _poSWVersionStatistic );
   #ifdef VARIANT_S_FTR_ENABLE_VARIANT_HANDLING
      SPM_FACTORY_DELETE( _variant );
   #endif

      SPM_FACTORY_DELETE( _poStartupLocal );

      SPM_FACTORY_DELETE( _poProcessDatabase );
      SPM_FACTORY_DELETE( _poProcessSupervision );
      SPM_FACTORY_DELETE( _poclRegistry );

   #ifdef VARIANT_S_FTR_ENABLE_INC_THERMALMANAGEMENT
      SPM_FACTORY_DELETE( _poclThermalMgmtServiceHandler );
   #endif
   #ifdef VARIANT_S_FTR_ENABLE_INC_SUPPLYMANAGEMENT
      SPM_FACTORY_DELETE( _poclSupplyMgmtServiceHandler );
   #endif
   #ifdef VARIANT_S_FTR_ENABLE_INC_SYSTEMSTATEMACHINE
      SPM_FACTORY_DELETE( _poclSystemStateMachineServiceHandler );
   #endif

      SPM_FACTORY_DELETE( _poWakeupHandler );
      SPM_FACTORY_DELETE( _poTimerHandler );
      SPM_FACTORY_DELETE( _poclIgnitionOffSupervisor );
      SPM_FACTORY_DELETE( _poSupervisionEnableSupervisor );
      SPM_FACTORY_DELETE( _poclSwitchOnStatistic );
      SPM_FACTORY_DELETE( _poclAppErrorHdl );
      SPM_FACTORY_DELETE( _poclSyncHdl );
      SPM_FACTORY_DELETE( _poclDownloadLockListManager );
}

