/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IFactory.h
  * @brief        This is header file contains interfaces to interact with Factory.
  * @copyright    (C) 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>

#include "spm_Config.h"
#include "spm_ISpmBase.h"

// forward declaration
class ISpmClientHandlerBase;

/*!
  *  \class ISpmFactory
  *  \brief This abstract class provides interfaces to interact with
  *         Factory.
  */
class ISpmFactory : public ISpmBase
{
private:
//avoid assignment
ISpmFactory & operator = (const ISpmFactory &corfoISpmFactory);
public:
// constructor
ISpmFactory( const ISpmFactory& factory ) : ISpmBase( factory ){ }
virtual ~ISpmFactory( ){ }

// only temporary till all GetInstance calls are removed
static ISpmFactory *_poFactoryRef;
static ISpmFactory*pGetInstance( ){ return( _poFactoryRef ); }

virtual const tChar*getInterfaceName( ) const { return( "ISpmFactory" ); }
virtual ISpmClientHandlerBase*getClientHandler( const std::string& strName ) const = 0;

virtual ISpmBase*getSpmObjHandler( const std::string& strName ) const              = 0;

virtual tBool bCreate( )                                                           = 0; // create SystemPowerManager + Startup Processes

virtual tVoid vStart( )                                                            = 0; // system startup, all in parallel threads

virtual tVoid vRunEnv( )                                                           = 0; // system startup, all in parallel threads

virtual tBool bGetFastShutdown( ) const                                            = 0;

virtual tVoid vAddFactoryClient( ISpmBase *client )                                = 0;

virtual tVoid vRemoveFactoryClient( ISpmBase *client )                             = 0;

virtual tVoid vAddFactoryClientHandler( ISpmClientHandlerBase *client )            = 0;

virtual tVoid vRemoveFactoryClientHandler( ISpmClientHandlerBase *client )         = 0;

virtual tVoid vStartAllLateCommunication( ) const                                  = 0;

virtual tBool bIsSpecialStartupRegActive( ) const                                  = 0;

virtual tBool bIsTargetUnconfigured( ) const                                       = 0;

virtual tBool bIsSWVersionUpdate( ) const                                          = 0;

};

