/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_WakeupStatistics.h
  * @brief        This is header file contains functions related to Wakeup Statistics of system..
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

#include "spm_IStatistics.h"

/*!
  *  \class spm_tclWakeupStatisticsTemplate
  *  \brief This class is used to handle Wakeup statistics of system. The template type
  *         T1: wakeup history data pool a list of TSpmWakeupStatisticsData type inside (contains time and wakeup type).
  *         T2: DeviceWakeupCount data pool of wakeup counter.
  */
template < typename T1, typename T2>
class spm_tclWakeupStatisticsTemplate : public ISpmStatistics
{
public:
spm_tclWakeupStatisticsTemplate( const ISpmFactory& factory, enStatisticsType eStatType );
virtual ~spm_tclWakeupStatisticsTemplate( );

virtual tVoid vSetNewData( tU32 u32StatisticType ) const;

virtual tVoid vGetData( void *pStatistics,
                        tU32  u32ObjectSize ) const;

virtual tVoid vErase( ) const;

virtual tVoid vTrace( ) const;

// implementation of functions needed for other statitics
virtual tBool bChkUnknownReset( tU32 /*u32StatisticType*/ ) const { return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetLastReset( TSpmResetElem */*pLastResetData*/ ) const { }             //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual std::string szAsString( ) const { return( "" ); }
virtual tVoid vUpdateResetCounter( tVoid ) const {}

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){ } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( ){ }
virtual tVoid vStartCommunication( ){ }
virtual const tChar*getName( ) const { return( "spm_tclWakeupStatisticsTemplate" ); }

};


/*!
  *  \class spm_tclWakeupStatistics
  *  \brief This class works for  Wakeup statistics of system.
          It uses class dp_tclSpmDpEngDataWupHistory to set , erase and trace statistics data.

        This is used by class spm_tclSystemStateManager for setting Wakeup data.

          The spm_tclFactory object creates an instance of this class.
  */
class spm_tclWakeupStatistics : public spm_tclWakeupStatisticsTemplate < dp_tclSpmDpEngDataWupHistory, dp_tclSpmDpEngDataDeviceWakeupCount >
{
public:
spm_tclWakeupStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclWakeupStatistics" ); }
};

/*!
  *  \class spm_tclSWVersionWakeupStatistics
  *  \brief This class works for  Wakeup statistics of system.
  */
class spm_tclSWVersionWakeupStatistics : public spm_tclWakeupStatisticsTemplate < dp_tclSpmDpEngDataCurrentSWVersionWupHistory, dp_tclSpmDpEngDataCurrentSWVersionDeviceWakeupCount >
{
public:
spm_tclSWVersionWakeupStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSWVersionWakeupStatistics" ); }
};
