/*!
  * \file spm_TransportmodeStatistics.cpp
  *  \brief
  *    Transportmode statistics of the system
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  *  Date      | Author            | Modification
  * 09.11.11  | TMS Fischer       | initial version
  ******
  */

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

// -----------------------------------------------------------------------------
// includes FC SPM
// -----------------------------------------------------------------------------
#include "spm_Config.h"
#include "spm_TransportmodeStatistics.h"
#include "spm_IOsalProxy.h"
#include "spm_IFactory.h"

#include "timeConvert.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
 #include "trcGenProj/Header/spm_TransportmodeStatistics.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/

// //#define SPM_TRACE_FILE_ID   SPM_FILE_TRANSPORTMODESTATISTICS

spm_tclTransportmodeStatistics::spm_tclTransportmodeStatistics( const ISpmFactory& factory )
   : ISpmStatistics( factory ){
}

spm_tclTransportmodeStatistics::~spm_tclTransportmodeStatistics( ){
}

tVoid spm_tclTransportmodeStatistics::vSetNewData( tU32 u32StatisticType ) const {
   (tVoid)u32StatisticType;
   dp_tclSpmDpEngDataTpHistory oHistory;

   OSAL_trTimeDate             rCurrentTime = { 0,0,0,0,0,0,0,0,0 };

   // get current time
   SPM_GET_IF_REFERENCE_NEW_VAR( poOsalProxy, ISpmOsalProxy );
   (tVoid)poOsalProxy->bGetUtcTime( &rCurrentTime );
   tclTimeConvert              oTimeConv;
   rCurrentTime.s32Year += 1900;
   tU32                        u32Seconds = oTimeConv.u32GetSeconds( &rCurrentTime );

   ETG_TRACE_USR4( ( "Transportmode detected at %04d-%02d-%02d  %02d:%02d:%02d (seconds since 1970: %d)",
                     rCurrentTime.s32Year, rCurrentTime.s32Month, rCurrentTime.s32Day,
                     rCurrentTime.s32Hour, rCurrentTime.s32Minute, rCurrentTime.s32Second,
                     u32Seconds ) );

   oHistory.vPushBack( u32Seconds );

} // vSetActive

tVoid spm_tclTransportmodeStatistics::vErase( ) const {
   dp_tclSpmDpEngDataTpHistory oHistory;

   oHistory.vClearList( );
}

tVoid spm_tclTransportmodeStatistics::vTrace( ) const {
   dp_tclSpmDpEngDataTpHistory oHistory;

   tU32                        u32Count = oHistory.u32GetCount( );

   for ( tUInt i = 0; i < u32Count; ++i ){
      tclTimeConvert  oTimeConv;
      tU32            u32Seconds = 0;
      OSAL_trTimeDate tTimeDate  = { 0,0,0,0,0,0,0,0,0 };

      oHistory.s32GetElem( i, u32Seconds );
      oTimeConv.vGetDateFromElapsedSeconds( u32Seconds, &tTimeDate );

      ETG_TRACE_FATAL( ( "TransportMode Date %2d:        %04d.%02d.%02d %02d:%02d:%02d (UTC)",
                         i + 1,
                         tTimeDate.s32Year, tTimeDate.s32Month, tTimeDate.s32Day,
                         tTimeDate.s32Hour, tTimeDate.s32Minute, tTimeDate.s32Second
                         ) );
   }
} // vTrace

