/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SystemStateStatistics.h
  * @brief        This is header file contains functions related to SystemState Statistics.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_ISystemStateStatistics.h"
#include "spm_SubStateDefines.h"

#define SPM_STATE_HISTORY_ENTRY_WAKEUP    0
#define SPM_STATE_HISTORY_ENTRY_SUBSTATE  1
#define SPM_STATE_HISTORY_ENTRY_RESET     2

/*!
  *  \class spm_tclSystemStateStatistics
  *  \brief This class works for systemState statistics of system .
          This class provide interfaces to add , erase and trace error history.

        This class is used by spm_tclSubStateHandler for systemState statistics data .

          The spm_tclFactory object creates an instance of this class.
  */
template < typename T1, typename T2,typename T3, typename T4, typename T5, typename T6, typename T7 >
class spm_tclSystemStateStatisticsTemplate : public ISpmSystemStateStatistics
{
public:
spm_tclSystemStateStatisticsTemplate( const ISpmFactory& factory, enStatisticsType eStatType );
virtual ~spm_tclSystemStateStatisticsTemplate( );

virtual tVoid vSetNewData( tU32 /*u32StatisticType*/ ) const { } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetData( void */*pStatisticsData*/,
                        tU32  /*u32ObjectSize = 0*/ ) const { }  //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vUpdateSystemStateHistory( TSpmSystemStateStatisticsData& oStateElem ) const;

virtual tVoid vGetDataSysStateHistory( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const;

virtual tVoid vGetDataErrSysStateStateHistoryStack01( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const;

virtual tVoid vGetDataErrSysStateStateHistoryStack02( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const;

virtual tVoid vGetDataErrSysStateStateHistoryStack03( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const;

virtual tVoid vGetDataErrSysStateStateHistoryStack04( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const;

virtual tVoid vGetDataErrSysStateStateHistoryStack05( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const;

virtual tVoid vErase( ) const;

virtual tVoid vTrace( ) const;

virtual tU32 u32AddErrorHistory( ) const;

virtual tVoid vEraseErrorHistory( ) const;

virtual tVoid vTraceErrorHistory( tU8 u8Number ) const;

template < typename S, typename T >
tVoid vCopyErrStateHistoryElements( S   & oErrStateHistorySrc,
                                    T   & oErrStateHistoryDest,
                                    tBool bCopyInReverseOrder ) const;

// implementation of functions needed for other statitics
virtual tBool bChkUnknownReset( tU32 /*u32StatisticType*/ ) const { return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetLastReset( TSpmResetElem */*pLastResetData*/ ) const { }             //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual std::string szAsString( ) const { return( "" ); }
virtual tVoid vUpdateResetCounter( tVoid ) const {}

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){ } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( ){ }
virtual tVoid vStartCommunication( ){ }
virtual const tChar*getName( ) const { return( "spm_tclSystemStateStatisticsTemplate" ); }
template < typename S >
tVoid vCopySysStateHistory( S &oStateHistorySrc ,TSpmSystemStateStatisticsData *pStatistics, tU32 u32ObjectSize ) const;

};


class spm_tclSystemStateStatistics : public spm_tclSystemStateStatisticsTemplate<dp_tclSpmDpEngStateHistoryStack01, dp_tclSpmDpEngStateHistoryStack02, dp_tclSpmDpEngStateHistoryStack03, dp_tclSpmDpEngStateHistoryStack04, dp_tclSpmDpEngStateHistoryStack05, dp_tclSpmDpEngStateLastHistoryStack ,dp_tclSpmDpEngStateHistory >
{
public:
spm_tclSystemStateStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSystemStateStatistics" ); }
};


class spm_tclSWVersionSystemStateStatistics : public spm_tclSystemStateStatisticsTemplate< dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01, dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02, dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03, dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04, dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05, dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack ,dp_tclSpmDpEngStateCurrentSWVersionHistory >
{
public:
spm_tclSWVersionSystemStateStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSWVersionSystemStateStatistics" ); }
};
