/*!
  * \file  spm_RamUsageStatistics_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclRamUsageStatistics_include_ext: user specific code start
#include "spm_factory.h"
#include "spm_SystemLoadStatistics.h"
// spm_tclRamUsageStatistics_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_RamUsageStatistics_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclRamUsageStatistics_include_spm: user specific code start
// spm_tclRamUsageStatistics_include_spm: user specific code end


tVoid spm_tclRamUsageStatistics::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SPMGETRAMUSAGESTATISTICS:
      {
         // Get RAM usage statistics with Max/Average/Min overall RAM usage of device. The RAM usage is percentage of ( total RAM size - free RAM size ) / ( total RAM size ).

         // SpmGetRamUsageStatistics: user specific code start
         vTrace( );
         // SpmGetRamUsageStatistics: user specific code end
      }
      break;

      case SPM_SPMERASERAMUSAGESTATISTICS:
      {
         // Erase RAM usage statistics

         // SpmEraseRamUsageStatistics: user specific code start
         vEraseLoading( );
         // SpmEraseRamUsageStatistics: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclRamUsageStatisticsFunction: user specific code start
     // spm_tclRamUsageStatisticsFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclRamUsageStatisticsFile: user specific code start
// spm_tclRamUsageStatisticsFile: user specific code end

