/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_PowerOnCount.h
  * @brief        This is header file contains functions to get or set PowerOnCount statistics data.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

#include <string>
#include "spm_IPowerOnStatistics.h"

/*!
  *  \class spm_tclPowerOnCountTemplate
  *  \brief This class is used to handle reset statistics of the system. The template type
  *         T1: PowerOnCount data pool time since device is started (in s)
  *         T2: LastSystemRunTime data pool last system runtime from start to shutdown (in s)
  */
template < typename T1, typename T2 >
class spm_tclPowerOnCountTemplate : public ISpmPowerOnStatistics
{
public:
spm_tclPowerOnCountTemplate( const ISpmFactory& factory, enStatisticsType eStatType );
virtual ~spm_tclPowerOnCountTemplate( );

virtual tVoid vCheckPwrOnTime( );

virtual tVoid vSetPwrOnTime( tU32 u32PwrOnTime );
virtual tVoid vSetPwrOnLastSystemRunTime( tU32 u32LastSystemRunTime );

virtual tU32 u32GetCurrentPwrOnTime( ) const { return( _u32CurrentPwrOnTime ); }

virtual tVoid vSetNewData( tU32 /*u32StatisticType*/ ) const { }          //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetData( void */*pStatisticsData*/,
                        tU32 /*u32ObjectSize = 0*/ ) const { } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vErase( ) const { }
virtual tVoid vTrace( ) const;

// implementation of functions needed for other statitics
virtual tBool bChkUnknownReset( tU32 /*u32StatisticType*/ ) const { return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetLastReset( TSpmResetElem */*pLastResetData*/ ) const { }             //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vUpdateResetCounter( tVoid ) const {}

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){ } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used


virtual std::string szAsString( ) const;

private:
tU32  _u32PwrOnTimeAtStartup;
tU32  _u32CurrentPwrOnTime;
tU32  _u32PwrOnStoredTime;
tU32  _u32SystemTimeSetOffset;

tBool _bPwrTimeValid;

ISpmPowerOnStatistics     *_pclsPowerOnStatistics;

protected:
virtual const tChar*getName( ) const { return( "spm_tclPowerOnCountTemplate" ); }
// ISpmBase interface functions
virtual tVoid vGetReferences( );
virtual tVoid vStartCommunication( );

virtual tVoid vStartLateCommunication( );

};

/*!
  *  \class spm_tclPowerOnCount
  *  \brief This class deals with power on counter of the system . It checks, sets and gives power on time .

        It is used by spm_tclSubStateHandler to check power on time..
        The spm_tclFactory object creates an instance of this class.

        it uses dp_tclSpmDpPowOnPowerOnCount class to set and check power on time.
  */
class spm_tclPowerOnCount : public spm_tclPowerOnCountTemplate< dp_tclSpmDpPowOnPowerOnCount, dp_tclSpmDpPowOnLastSystemRunTime >
{
public:
spm_tclPowerOnCount( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclPowerOnCount" ); }
};

/*!
  *  \class spm_tclSWVersionPowerOnCount
  *  \brief This class deals with power on counter of the system . It checks, sets and gives power on time .

        It is used by spm_tclSubStateHandler to check power on time..
        The spm_tclFactory object creates an instance of this class.

        it uses dp_tclSpmDpPowOnPowerOnCount class to set and check power on time.
  */
class spm_tclSWVersionPowerOnCount : public spm_tclPowerOnCountTemplate< dp_tclSpmDpPowOnCurrentSWVersionPowerOnCount, dp_tclSpmDpPowOnCurrentSWVersionLastSystemRunTime >
{
public:
spm_tclSWVersionPowerOnCount( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSWVersionPowerOnCount" ); }
};
